/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.handler;

import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.util.PathMatcher;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.handler.MappedInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MappedInterceptors {
    private MappedInterceptor[] mappedInterceptors;

    public MappedInterceptors(MappedInterceptor[] mappedInterceptors) {
        this.mappedInterceptors = mappedInterceptors;
    }

    public Set<HandlerInterceptor> getInterceptors(String lookupPath, PathMatcher pathMatcher) {
        LinkedHashSet<HandlerInterceptor> interceptors = new LinkedHashSet<HandlerInterceptor>();
        MappedInterceptor[] mappedInterceptorArray = this.mappedInterceptors;
        int n2 = this.mappedInterceptors.length;
        int n3 = 0;
        while (n3 < n2) {
            MappedInterceptor interceptor = mappedInterceptorArray[n3];
            if (this.matches(interceptor, lookupPath, pathMatcher)) {
                interceptors.add(interceptor.getInterceptor());
            }
            ++n3;
        }
        return interceptors;
    }

    private boolean matches(MappedInterceptor interceptor, String lookupPath, PathMatcher pathMatcher) {
        String[] pathPatterns = interceptor.getPathPatterns();
        if (pathPatterns != null) {
            String[] stringArray = pathPatterns;
            int n2 = pathPatterns.length;
            int n3 = 0;
            while (n3 < n2) {
                String pattern = stringArray[n3];
                if (pathMatcher.match(pattern, lookupPath)) {
                    return true;
                }
                ++n3;
            }
            return false;
        }
        return true;
    }
}

