/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.filter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.springframework.util.DigestUtils;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public class ShallowEtagHeaderFilter
extends OncePerRequestFilter {
    private static String HEADER_ETAG = "ETag";
    private static String HEADER_IF_NONE_MATCH = "If-None-Match";

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        ShallowEtagResponseWrapper responseWrapper = new ShallowEtagResponseWrapper(response);
        filterChain.doFilter(request, responseWrapper);
        byte[] body = responseWrapper.toByteArray();
        int statusCode = responseWrapper.getStatusCode();
        if (this.isEligibleForEtag(request, responseWrapper, statusCode, body)) {
            String responseETag = this.generateETagHeaderValue(body);
            response.setHeader(HEADER_ETAG, responseETag);
            String requestETag = request.getHeader(HEADER_IF_NONE_MATCH);
            if (responseETag.equals(requestETag)) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("ETag [" + responseETag + "] equal to If-None-Match, sending 304");
                }
                response.setContentLength(0);
                response.setStatus(304);
            } else {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("ETag [" + responseETag + "] not equal to If-None-Match [" + requestETag + "], sending normal response");
                }
                this.copyBodyToResponse(body, response);
            }
        } else {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Response with status code [" + statusCode + "] not eligible for ETag");
            }
            this.copyBodyToResponse(body, response);
        }
    }

    private void copyBodyToResponse(byte[] body, HttpServletResponse response) throws IOException {
        response.setContentLength(body.length);
        if (body.length > 0) {
            FileCopyUtils.copy(body, (OutputStream)response.getOutputStream());
        }
    }

    protected boolean isEligibleForEtag(HttpServletRequest request, HttpServletResponse response, int responseStatusCode, byte[] responseBody) {
        return responseStatusCode >= 200 && responseStatusCode < 300;
    }

    protected String generateETagHeaderValue(byte[] bytes) {
        StringBuilder builder = new StringBuilder("\"0");
        DigestUtils.appendMd5DigestAsHex(bytes, builder);
        builder.append('\"');
        return builder.toString();
    }

    private static class ShallowEtagResponseWrapper
    extends HttpServletResponseWrapper {
        private final ByteArrayOutputStream content = new ByteArrayOutputStream();
        private final ServletOutputStream outputStream = new ResponseServletOutputStream();
        private PrintWriter writer;
        private int statusCode = 200;

        private ShallowEtagResponseWrapper(HttpServletResponse response) {
            super(response);
        }

        public void setStatus(int sc) {
            super.setStatus(sc);
            this.statusCode = sc;
        }

        public void setStatus(int sc, String sm) {
            super.setStatus(sc, sm);
            this.statusCode = sc;
        }

        public void sendError(int sc) throws IOException {
            super.sendError(sc);
            this.statusCode = sc;
        }

        public void sendError(int sc, String msg) throws IOException {
            super.sendError(sc, msg);
            this.statusCode = sc;
        }

        public ServletOutputStream getOutputStream() {
            return this.outputStream;
        }

        public PrintWriter getWriter() throws IOException {
            if (this.writer == null) {
                String characterEncoding = this.getCharacterEncoding();
                this.writer = characterEncoding != null ? new ResponsePrintWriter(characterEncoding) : new ResponsePrintWriter("ISO-8859-1");
            }
            return this.writer;
        }

        public void resetBuffer() {
            this.content.reset();
        }

        public void reset() {
            super.reset();
            this.resetBuffer();
        }

        private int getStatusCode() {
            return this.statusCode;
        }

        private byte[] toByteArray() {
            return this.content.toByteArray();
        }

        private class ResponsePrintWriter
        extends PrintWriter {
            private ResponsePrintWriter(String characterEncoding) throws UnsupportedEncodingException {
                super(new OutputStreamWriter((OutputStream)ShallowEtagResponseWrapper.this.content, characterEncoding));
            }

            public void write(char[] buf, int off, int len) {
                super.write(buf, off, len);
                super.flush();
            }

            public void write(String s2, int off, int len) {
                super.write(s2, off, len);
                super.flush();
            }

            public void write(int c2) {
                super.write(c2);
                super.flush();
            }
        }

        private class ResponseServletOutputStream
        extends ServletOutputStream {
            private ResponseServletOutputStream() {
            }

            public void write(int b2) throws IOException {
                ShallowEtagResponseWrapper.this.content.write(b2);
            }

            public void write(byte[] b2, int off, int len) throws IOException {
                ShallowEtagResponseWrapper.this.content.write(b2, off, len);
            }
        }
    }
}

