/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.support;

import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.annotation.AnnotatedBeanDefinitionReader;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.context.annotation.ScopeMetadataResolver;
import org.springframework.web.context.support.AbstractRefreshableWebApplicationContext;

public class AnnotationConfigWebApplicationContext
extends AbstractRefreshableWebApplicationContext {
    protected void loadBeanDefinitions(DefaultListableBeanFactory beanFactory) {
        String[] configLocations;
        AnnotatedBeanDefinitionReader reader = new AnnotatedBeanDefinitionReader(beanFactory);
        ClassPathBeanDefinitionScanner scanner = new ClassPathBeanDefinitionScanner(beanFactory);
        BeanNameGenerator beanNameGenerator = this.getBeanNameGenerator();
        ScopeMetadataResolver scopeMetadataResolver = this.getScopeMetadataResolver();
        if (beanNameGenerator != null) {
            reader.setBeanNameGenerator(beanNameGenerator);
            scanner.setBeanNameGenerator(beanNameGenerator);
        }
        if (scopeMetadataResolver != null) {
            reader.setScopeMetadataResolver(scopeMetadataResolver);
            scanner.setScopeMetadataResolver(scopeMetadataResolver);
        }
        if ((configLocations = this.getConfigLocations()) != null) {
            String[] stringArray = configLocations;
            int n2 = configLocations.length;
            int n3 = 0;
            while (n3 < n2) {
                block9: {
                    String configLocation = stringArray[n3];
                    try {
                        Class<?> clazz = this.getClassLoader().loadClass(configLocation);
                        if (this.logger.isInfoEnabled()) {
                            this.logger.info("Successfully resolved class for [" + configLocation + "]");
                        }
                        reader.register(clazz);
                    }
                    catch (ClassNotFoundException ex) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("Could not load class for config location [" + configLocation + "] - trying package scan. " + ex);
                        }
                        int count = scanner.scan(configLocation);
                        if (!this.logger.isInfoEnabled()) break block9;
                        if (count == 0) {
                            this.logger.info("No annotated classes found for specified class/package [" + configLocation + "]");
                        }
                        this.logger.info("Found " + count + " annotated classes in package [" + configLocation + "]");
                    }
                }
                ++n3;
            }
        }
    }

    protected BeanNameGenerator getBeanNameGenerator() {
        return null;
    }

    protected ScopeMetadataResolver getScopeMetadataResolver() {
        return null;
    }
}

