/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.util;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AntPathStringMatcher {
    private static final Pattern GLOB_PATTERN = Pattern.compile("\\?|\\*|\\{([^/]+?)\\}");
    private static final String DEFAULT_VARIABLE_PATTERN = "(.*)";
    private final Pattern pattern;
    private String str;
    private final List<String> variableNames = new LinkedList<String>();
    private final Map<String, String> uriTemplateVariables;

    AntPathStringMatcher(String pattern, String str, Map<String, String> uriTemplateVariables) {
        this.str = str;
        this.uriTemplateVariables = uriTemplateVariables;
        this.pattern = this.createPattern(pattern);
    }

    private Pattern createPattern(String pattern) {
        StringBuilder patternBuilder = new StringBuilder();
        Matcher m2 = GLOB_PATTERN.matcher(pattern);
        int end = 0;
        while (m2.find()) {
            patternBuilder.append(this.quote(pattern, end, m2.start()));
            String match = m2.group();
            if ("?".equals(match)) {
                patternBuilder.append('.');
            } else if ("*".equals(match)) {
                patternBuilder.append(".*");
            } else if (match.startsWith("{") && match.endsWith("}")) {
                int colonIdx = match.indexOf(58);
                if (colonIdx == -1) {
                    patternBuilder.append(DEFAULT_VARIABLE_PATTERN);
                    this.variableNames.add(m2.group(1));
                } else {
                    String variablePattern = match.substring(colonIdx + 1, match.length() - 1);
                    patternBuilder.append('(');
                    patternBuilder.append(variablePattern);
                    patternBuilder.append(')');
                    String variableName = match.substring(1, colonIdx);
                    this.variableNames.add(variableName);
                }
            }
            end = m2.end();
        }
        patternBuilder.append(this.quote(pattern, end, pattern.length()));
        return Pattern.compile(patternBuilder.toString());
    }

    private String quote(String s2, int start, int end) {
        if (start == end) {
            return "";
        }
        return Pattern.quote(s2.substring(start, end));
    }

    public boolean matchStrings() {
        Matcher matcher = this.pattern.matcher(this.str);
        if (matcher.matches()) {
            if (this.uriTemplateVariables != null) {
                int i2 = 1;
                while (i2 <= matcher.groupCount()) {
                    String name = this.variableNames.get(i2 - 1);
                    String value = matcher.group(i2);
                    this.uriTemplateVariables.put(name, value);
                    ++i2;
                }
            }
            return true;
        }
        return false;
    }
}

