/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.remoting.dns;

import java.util.Hashtable;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import org.springframework.security.remoting.dns.DnsEntryNotFoundException;
import org.springframework.security.remoting.dns.DnsLookupException;
import org.springframework.security.remoting.dns.DnsResolver;
import org.springframework.security.remoting.dns.InitialContextFactory;

public class JndiDnsResolver
implements DnsResolver {
    private InitialContextFactory ctxFactory = new DefaultInitialContextFactory();

    public void setCtxFactory(InitialContextFactory ctxFactory) {
        this.ctxFactory = ctxFactory;
    }

    public String resolveIpAddress(String hostname) {
        return this.resolveIpAddress(hostname, this.ctxFactory.getCtx());
    }

    public String resolveServiceEntry(String serviceType, String domain) {
        return this.resolveServiceEntry(serviceType, domain, this.ctxFactory.getCtx());
    }

    public String resolveServiceIpAddress(String serviceType, String domain) {
        DirContext ctx = this.ctxFactory.getCtx();
        String hostname = this.resolveServiceEntry(serviceType, domain, ctx);
        return this.resolveIpAddress(hostname, ctx);
    }

    private String resolveIpAddress(String hostname, DirContext ctx) {
        try {
            Attribute dnsRecord = this.lookup(hostname, ctx, "A");
            return dnsRecord.get().toString();
        }
        catch (NamingException e2) {
            throw new DnsLookupException("DNS lookup failed for: " + hostname, e2);
        }
    }

    private String resolveServiceEntry(String serviceType, String domain, DirContext ctx) {
        String result = null;
        try {
            String query = "_" + serviceType + "._tcp." + domain;
            Attribute dnsRecord = this.lookup(query, ctx, "SRV");
            int highestPriority = -1;
            int highestWeight = -1;
            NamingEnumeration<?> recordEnum = dnsRecord.getAll();
            while (recordEnum.hasMoreElements()) {
                String[] record = recordEnum.next().toString().split(" ");
                if (record.length != 4) {
                    throw new DnsLookupException("Wrong service record for query " + query + ": [" + record + "]");
                }
                int priority = Integer.parseInt(record[0]);
                int weight = Integer.parseInt(record[1]);
                if (priority < highestPriority || highestPriority == -1) {
                    highestPriority = priority;
                    highestWeight = weight;
                    result = record[3].trim();
                }
                if (priority != highestPriority || weight <= highestWeight) continue;
                highestWeight = weight;
                result = record[3].trim();
            }
        }
        catch (NamingException e2) {
            throw new DnsLookupException("DNS lookup failed for service " + serviceType + " at " + domain, e2);
        }
        if (result.endsWith(".")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    private Attribute lookup(String query, DirContext ictx, String recordType) {
        try {
            Attributes dnsResult = ictx.getAttributes(query, new String[]{recordType});
            Attribute dnsRecord = dnsResult.get(recordType);
            return dnsRecord;
        }
        catch (NamingException e2) {
            if (e2 instanceof NameNotFoundException) {
                throw new DnsEntryNotFoundException("DNS entry not found for:" + query, e2);
            }
            throw new DnsLookupException("DNS lookup failed for: " + query, e2);
        }
    }

    private static class DefaultInitialContextFactory
    implements InitialContextFactory {
        private DefaultInitialContextFactory() {
        }

        public DirContext getCtx() {
            InitialDirContext ictx;
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
            env.put("java.naming.provider.url", "dns:");
            try {
                ictx = new InitialDirContext(env);
            }
            catch (NamingException e2) {
                throw new DnsLookupException("Cannot create InitialDirContext for DNS lookup", e2);
            }
            return ictx;
        }
    }
}

