/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web.portlet;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.activation.FileTypeMap;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequestDispatcher;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.mock.web.portlet.MockPortletRequestDispatcher;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockPortletContext
implements PortletContext {
    private static final String TEMP_DIR_SYSTEM_PROPERTY = "java.io.tmpdir";
    private final Log logger = LogFactory.getLog(this.getClass());
    private final String resourceBasePath;
    private final ResourceLoader resourceLoader;
    private final Map<String, Object> attributes = new LinkedHashMap<String, Object>();
    private final Map<String, String> initParameters = new LinkedHashMap<String, String>();
    private String portletContextName = "MockPortletContext";
    private Set<String> containerRuntimeOptions = new LinkedHashSet<String>();

    public MockPortletContext() {
        this("", null);
    }

    public MockPortletContext(String resourceBasePath) {
        this(resourceBasePath, null);
    }

    public MockPortletContext(ResourceLoader resourceLoader) {
        this("", resourceLoader);
    }

    public MockPortletContext(String resourceBasePath, ResourceLoader resourceLoader) {
        this.resourceBasePath = resourceBasePath != null ? resourceBasePath : "";
        this.resourceLoader = resourceLoader != null ? resourceLoader : new DefaultResourceLoader();
        String tempDir = System.getProperty(TEMP_DIR_SYSTEM_PROPERTY);
        if (tempDir != null) {
            this.attributes.put("javax.servlet.context.tempdir", new File(tempDir));
        }
    }

    protected String getResourceLocation(String path) {
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return String.valueOf(this.resourceBasePath) + path;
    }

    public String getServerInfo() {
        return "MockPortal/1.0";
    }

    public PortletRequestDispatcher getRequestDispatcher(String path) {
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("PortletRequestDispatcher path at PortletContext level must start with '/'");
        }
        return new MockPortletRequestDispatcher(path);
    }

    public PortletRequestDispatcher getNamedDispatcher(String path) {
        return null;
    }

    public InputStream getResourceAsStream(String path) {
        Resource resource = this.resourceLoader.getResource(this.getResourceLocation(path));
        try {
            return resource.getInputStream();
        }
        catch (IOException ex) {
            this.logger.info("Couldn't open InputStream for " + resource, ex);
            return null;
        }
    }

    public int getMajorVersion() {
        return 2;
    }

    public int getMinorVersion() {
        return 0;
    }

    public String getMimeType(String filePath) {
        return MimeTypeResolver.getMimeType(filePath);
    }

    public String getRealPath(String path) {
        Resource resource = this.resourceLoader.getResource(this.getResourceLocation(path));
        try {
            return resource.getFile().getAbsolutePath();
        }
        catch (IOException ex) {
            this.logger.info("Couldn't determine real path of resource " + resource, ex);
            return null;
        }
    }

    public Set<String> getResourcePaths(String path) {
        Resource resource = this.resourceLoader.getResource(this.getResourceLocation(path));
        try {
            File file = resource.getFile();
            String[] fileList = file.list();
            String prefix = path.endsWith("/") ? path : String.valueOf(path) + "/";
            HashSet<String> resourcePaths = new HashSet<String>(fileList.length);
            String[] stringArray = fileList;
            int n2 = fileList.length;
            int n3 = 0;
            while (n3 < n2) {
                String fileEntry = stringArray[n3];
                resourcePaths.add(String.valueOf(prefix) + fileEntry);
                ++n3;
            }
            return resourcePaths;
        }
        catch (IOException ex) {
            this.logger.info("Couldn't get resource paths for " + resource, ex);
            return null;
        }
    }

    public URL getResource(String path) throws MalformedURLException {
        Resource resource = this.resourceLoader.getResource(this.getResourceLocation(path));
        try {
            return resource.getURL();
        }
        catch (IOException ex) {
            this.logger.info("Couldn't get URL for " + resource, ex);
            return null;
        }
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        return new Vector(this.attributes.keySet()).elements();
    }

    public void setAttribute(String name, Object value) {
        if (value != null) {
            this.attributes.put(name, value);
        } else {
            this.attributes.remove(name);
        }
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public void addInitParameter(String name, String value) {
        Assert.notNull(name, "Parameter name must not be null");
        this.initParameters.put(name, value);
    }

    public String getInitParameter(String name) {
        Assert.notNull(name, "Parameter name must not be null");
        return this.initParameters.get(name);
    }

    public Enumeration<String> getInitParameterNames() {
        return Collections.enumeration((Collection)this.initParameters.keySet());
    }

    public void log(String message) {
        this.logger.info(message);
    }

    public void log(String message, Throwable t) {
        this.logger.info(message, t);
    }

    public void setPortletContextName(String portletContextName) {
        this.portletContextName = portletContextName;
    }

    public String getPortletContextName() {
        return this.portletContextName;
    }

    public void addContainerRuntimeOption(String key) {
        this.containerRuntimeOptions.add(key);
    }

    public Enumeration<String> getContainerRuntimeOptions() {
        return Collections.enumeration(this.containerRuntimeOptions);
    }

    private static class MimeTypeResolver {
        private MimeTypeResolver() {
        }

        public static String getMimeType(String filePath) {
            return FileTypeMap.getDefaultFileTypeMap().getContentType(filePath);
        }
    }
}

