/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core.namedparam;

import java.util.HashMap;
import java.util.Map;
import org.springframework.jdbc.core.SqlParameterValue;
import org.springframework.jdbc.core.namedparam.BeanPropertySqlParameterSource;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class SqlParameterSourceUtils {
    public static SqlParameterSource[] createBatch(Map[] valueMaps) {
        SqlParameterSource[] batch = new MapSqlParameterSource[valueMaps.length];
        int i2 = 0;
        while (i2 < valueMaps.length) {
            Map valueMap = valueMaps[i2];
            batch[i2] = new MapSqlParameterSource(valueMap);
            ++i2;
        }
        return batch;
    }

    public static SqlParameterSource[] createBatch(Object[] beans) {
        SqlParameterSource[] batch = new BeanPropertySqlParameterSource[beans.length];
        int i2 = 0;
        while (i2 < beans.length) {
            Object bean = beans[i2];
            batch[i2] = new BeanPropertySqlParameterSource(bean);
            ++i2;
        }
        return batch;
    }

    public static Object getTypedValue(SqlParameterSource source, String parameterName) {
        int sqlType = source.getSqlType(parameterName);
        if (sqlType != Integer.MIN_VALUE) {
            if (source.getTypeName(parameterName) != null) {
                return new SqlParameterValue(sqlType, source.getTypeName(parameterName), source.getValue(parameterName));
            }
            return new SqlParameterValue(sqlType, source.getValue(parameterName));
        }
        return source.getValue(parameterName);
    }

    public static Map extractCaseInsensitiveParameterNames(SqlParameterSource parameterSource) {
        HashMap<String, String> caseInsensitiveParameterNames;
        block3: {
            block2: {
                caseInsensitiveParameterNames = new HashMap<String, String>();
                if (!(parameterSource instanceof BeanPropertySqlParameterSource)) break block2;
                String[] propertyNames = ((BeanPropertySqlParameterSource)parameterSource).getReadablePropertyNames();
                int i2 = 0;
                while (i2 < propertyNames.length) {
                    String name = propertyNames[i2];
                    caseInsensitiveParameterNames.put(name.toLowerCase(), name);
                    ++i2;
                }
                break block3;
            }
            if (!(parameterSource instanceof MapSqlParameterSource)) break block3;
            for (String name : ((MapSqlParameterSource)parameterSource).getValues().keySet()) {
                caseInsensitiveParameterNames.put(name.toLowerCase(), name);
            }
        }
        return caseInsensitiveParameterNames;
    }
}

