/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core.namedparam;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.core.SqlParameterValue;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.ParsedSql;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NamedParameterUtils {
    private static final char[] PARAMETER_SEPARATORS = new char[]{'\"', '\'', ':', '&', ',', ';', '(', ')', '|', '=', '+', '-', '*', '%', '/', '\\', '<', '>', '^'};
    private static final String[] START_SKIP = new String[]{"'", "\"", "--", "/*"};
    private static final String[] STOP_SKIP = new String[]{"'", "\"", "\n", "*/"};

    /*
     * Unable to fully structure code
     */
    public static ParsedSql parseSqlStatement(String sql) {
        Assert.notNull(sql, "SQL must not be null");
        namedParameters = new HashSet<String>();
        parsedSql = new ParsedSql(sql);
        statement = sql.toCharArray();
        namedParameterCount = 0;
        unnamedParameterCount = 0;
        totalParameterCount = 0;
        i = 0;
        while (i < statement.length) {
            block7: {
                block6: {
                    skipToPosition = NamedParameterUtils.skipCommentsAndQuotes(statement, i);
                    if (i != skipToPosition) {
                        if (skipToPosition >= statement.length) break;
                        i = skipToPosition;
                    }
                    if ((c = statement[i]) != ':' && c != '&') break block6;
                    j = i + 1;
                    if (j >= statement.length || statement[j] != ':' || c != ':') ** GOTO lbl20
                    i += 2;
                    continue;
lbl-1000:
                    // 1 sources

                    {
                        ++j;
lbl20:
                        // 2 sources

                        ** while (j < statement.length && !NamedParameterUtils.isParameterSeparator((char)statement[j]))
                    }
lbl21:
                    // 1 sources

                    if (j - i > 1) {
                        parameter = sql.substring(i + 1, j);
                        if (!namedParameters.contains(parameter)) {
                            namedParameters.add(parameter);
                            ++namedParameterCount;
                        }
                        parsedSql.addNamedParameter(parameter, i, j);
                        ++totalParameterCount;
                    }
                    i = j - 1;
                    break block7;
                }
                if (c == '?') {
                    ++unnamedParameterCount;
                    ++totalParameterCount;
                }
            }
            ++i;
        }
        parsedSql.setNamedParameterCount(namedParameterCount);
        parsedSql.setUnnamedParameterCount(unnamedParameterCount);
        parsedSql.setTotalParameterCount(totalParameterCount);
        return parsedSql;
    }

    private static int skipCommentsAndQuotes(char[] statement, int position) {
        int i2 = 0;
        while (i2 < START_SKIP.length) {
            if (statement[position] == START_SKIP[i2].charAt(0)) {
                boolean match = true;
                int j2 = 1;
                while (j2 < START_SKIP[i2].length()) {
                    if (statement[position + j2] != START_SKIP[i2].charAt(j2)) {
                        match = false;
                        break;
                    }
                    ++j2;
                }
                if (match) {
                    int offset = START_SKIP[i2].length();
                    int m2 = position + offset;
                    while (m2 < statement.length) {
                        if (statement[m2] == STOP_SKIP[i2].charAt(0)) {
                            boolean endMatch = true;
                            int endPos = m2;
                            int n2 = 1;
                            while (n2 < STOP_SKIP[i2].length()) {
                                if (m2 + n2 >= statement.length) {
                                    return statement.length;
                                }
                                if (statement[m2 + n2] != STOP_SKIP[i2].charAt(n2)) {
                                    endMatch = false;
                                    break;
                                }
                                endPos = m2 + n2;
                                ++n2;
                            }
                            if (endMatch) {
                                return endPos + 1;
                            }
                        }
                        ++m2;
                    }
                    return statement.length;
                }
            }
            ++i2;
        }
        return position;
    }

    public static String substituteNamedParameters(ParsedSql parsedSql, SqlParameterSource paramSource) {
        String originalSql = parsedSql.getOriginalSql();
        StringBuilder actualSql = new StringBuilder();
        List<String> paramNames = parsedSql.getParameterNames();
        int lastIndex = 0;
        int i2 = 0;
        while (i2 < paramNames.size()) {
            String paramName = paramNames.get(i2);
            int[] indexes = parsedSql.getParameterIndexes(i2);
            int startIndex = indexes[0];
            int endIndex = indexes[1];
            actualSql.append(originalSql.substring(lastIndex, startIndex));
            if (paramSource != null && paramSource.hasValue(paramName)) {
                Object value = paramSource.getValue(paramName);
                if (value instanceof Collection) {
                    Iterator entryIter = ((Collection)value).iterator();
                    int k2 = 0;
                    while (entryIter.hasNext()) {
                        if (k2 > 0) {
                            actualSql.append(", ");
                        }
                        ++k2;
                        Object entryItem = entryIter.next();
                        if (entryItem instanceof Object[]) {
                            Object[] expressionList = (Object[])entryItem;
                            actualSql.append("(");
                            int m2 = 0;
                            while (m2 < expressionList.length) {
                                if (m2 > 0) {
                                    actualSql.append(", ");
                                }
                                actualSql.append("?");
                                ++m2;
                            }
                            actualSql.append(")");
                            continue;
                        }
                        actualSql.append("?");
                    }
                } else {
                    actualSql.append("?");
                }
            } else {
                actualSql.append("?");
            }
            lastIndex = endIndex;
            ++i2;
        }
        actualSql.append(originalSql.substring(lastIndex, originalSql.length()));
        return actualSql.toString();
    }

    public static Object[] buildValueArray(ParsedSql parsedSql, SqlParameterSource paramSource, List<SqlParameter> declaredParams) {
        Object[] paramArray = new Object[parsedSql.getTotalParameterCount()];
        if (parsedSql.getNamedParameterCount() > 0 && parsedSql.getUnnamedParameterCount() > 0) {
            throw new InvalidDataAccessApiUsageException("You can't mix named and traditional ? placeholders. You have " + parsedSql.getNamedParameterCount() + " named parameter(s) and " + parsedSql.getUnnamedParameterCount() + " traditonal placeholder(s) in [" + parsedSql.getOriginalSql() + "]");
        }
        List<String> paramNames = parsedSql.getParameterNames();
        int i2 = 0;
        while (i2 < paramNames.size()) {
            String paramName = paramNames.get(i2);
            try {
                Object value = paramSource.getValue(paramName);
                SqlParameter param = NamedParameterUtils.findParameter(declaredParams, paramName, i2);
                paramArray[i2] = param != null ? new SqlParameterValue(param, value) : value;
            }
            catch (IllegalArgumentException ex) {
                throw new InvalidDataAccessApiUsageException("No value supplied for the SQL parameter '" + paramName + "': " + ex.getMessage());
            }
            ++i2;
        }
        return paramArray;
    }

    private static SqlParameter findParameter(List<SqlParameter> declaredParams, String paramName, int paramIndex) {
        if (declaredParams != null) {
            SqlParameter declaredParam2;
            for (SqlParameter declaredParam2 : declaredParams) {
                if (!paramName.equals(declaredParam2.getName())) continue;
                return declaredParam2;
            }
            if (paramIndex < declaredParams.size() && (declaredParam2 = declaredParams.get(paramIndex)).getName() == null) {
                return declaredParam2;
            }
        }
        return null;
    }

    private static boolean isParameterSeparator(char c2) {
        if (Character.isWhitespace(c2)) {
            return true;
        }
        char[] cArray = PARAMETER_SEPARATORS;
        int n2 = PARAMETER_SEPARATORS.length;
        int n3 = 0;
        while (n3 < n2) {
            char separator = cArray[n3];
            if (c2 == separator) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public static int[] buildSqlTypeArray(ParsedSql parsedSql, SqlParameterSource paramSource) {
        int[] sqlTypes = new int[parsedSql.getTotalParameterCount()];
        List<String> paramNames = parsedSql.getParameterNames();
        int i2 = 0;
        while (i2 < paramNames.size()) {
            String paramName = paramNames.get(i2);
            sqlTypes[i2] = paramSource.getSqlType(paramName);
            ++i2;
        }
        return sqlTypes;
    }

    public static String parseSqlStatementIntoString(String sql) {
        ParsedSql parsedSql = NamedParameterUtils.parseSqlStatement(sql);
        return NamedParameterUtils.substituteNamedParameters(parsedSql, null);
    }

    public static String substituteNamedParameters(String sql, SqlParameterSource paramSource) {
        ParsedSql parsedSql = NamedParameterUtils.parseSqlStatement(sql);
        return NamedParameterUtils.substituteNamedParameters(parsedSql, paramSource);
    }

    public static Object[] buildValueArray(String sql, Map<String, ?> paramMap) {
        ParsedSql parsedSql = NamedParameterUtils.parseSqlStatement(sql);
        return NamedParameterUtils.buildValueArray(parsedSql, new MapSqlParameterSource(paramMap), null);
    }
}

