/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.support;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.AccessException;
import org.springframework.expression.ConstructorExecutor;
import org.springframework.expression.ConstructorResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.spel.support.ReflectionHelper;
import org.springframework.expression.spel.support.ReflectiveConstructorExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectiveConstructorResolver
implements ConstructorResolver {
    @Override
    public ConstructorExecutor resolve(EvaluationContext context, String typename, List<TypeDescriptor> argumentTypes) throws AccessException {
        try {
            TypeConverter typeConverter = context.getTypeConverter();
            Class<?> type = context.getTypeLocator().findType(typename);
            Constructor<?>[] ctors = type.getConstructors();
            Arrays.sort(ctors, new Comparator<Constructor>(){

                @Override
                public int compare(Constructor c1, Constructor c2) {
                    int c1pl = c1.getParameterTypes().length;
                    int c2pl = c2.getParameterTypes().length;
                    return new Integer(c1pl).compareTo(c2pl);
                }
            });
            Constructor<?> closeMatch = null;
            int[] argsToConvert = null;
            Constructor<?> matchRequiringConversion = null;
            Constructor<?>[] constructorArray = ctors;
            int n2 = ctors.length;
            int n3 = 0;
            while (n3 < n2) {
                Constructor<?> ctor = constructorArray[n3];
                Class<?>[] paramTypes = ctor.getParameterTypes();
                ArrayList<TypeDescriptor> paramDescriptors = new ArrayList<TypeDescriptor>(paramTypes.length);
                int i2 = 0;
                while (i2 < paramTypes.length) {
                    paramDescriptors.add(new TypeDescriptor(new MethodParameter(ctor, i2)));
                    ++i2;
                }
                ReflectionHelper.ArgumentsMatchInfo matchInfo = null;
                if (ctor.isVarArgs() && argumentTypes.size() >= paramTypes.length - 1) {
                    matchInfo = ReflectionHelper.compareArgumentsVarargs(paramDescriptors, argumentTypes, typeConverter);
                } else if (paramTypes.length == argumentTypes.size()) {
                    matchInfo = ReflectionHelper.compareArguments(paramDescriptors, argumentTypes, typeConverter);
                }
                if (matchInfo != null) {
                    if (matchInfo.kind == ReflectionHelper.ArgsMatchKind.EXACT) {
                        return new ReflectiveConstructorExecutor(ctor, null);
                    }
                    if (matchInfo.kind == ReflectionHelper.ArgsMatchKind.CLOSE) {
                        closeMatch = ctor;
                    } else if (matchInfo.kind == ReflectionHelper.ArgsMatchKind.REQUIRES_CONVERSION) {
                        argsToConvert = matchInfo.argsRequiringConversion;
                        matchRequiringConversion = ctor;
                    }
                }
                ++n3;
            }
            if (closeMatch != null) {
                return new ReflectiveConstructorExecutor(closeMatch, null);
            }
            if (matchRequiringConversion != null) {
                return new ReflectiveConstructorExecutor(matchRequiringConversion, argsToConvert);
            }
            return null;
        }
        catch (EvaluationException ex) {
            throw new AccessException("Failed to resolve constructor", ex);
        }
    }
}

