/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.standard;

import org.springframework.expression.spel.standard.TokenKind;

class Token {
    TokenKind kind;
    String data;
    int startpos;
    int endpos;

    Token(TokenKind tokenKind, int startpos, int endpos) {
        this.kind = tokenKind;
        this.startpos = startpos;
        this.endpos = endpos;
    }

    Token(TokenKind tokenKind, char[] tokenData, int pos, int endpos) {
        this(tokenKind, pos, endpos);
        this.data = new String(tokenData);
    }

    public TokenKind getKind() {
        return this.kind;
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder();
        s2.append("[").append(this.kind.toString());
        if (this.kind.hasPayload()) {
            s2.append(":").append(this.data);
        }
        s2.append("]");
        s2.append("(").append(this.startpos).append(",").append(this.endpos).append(")");
        return s2.toString();
    }

    public boolean isIdentifier() {
        return this.kind == TokenKind.IDENTIFIER;
    }

    public boolean isNumericRelationalOperator() {
        return this.kind == TokenKind.GT || this.kind == TokenKind.GE || this.kind == TokenKind.LT || this.kind == TokenKind.LE || this.kind == TokenKind.EQ || this.kind == TokenKind.NE;
    }

    public String stringValue() {
        return this.data;
    }

    public Token asInstanceOfToken() {
        return new Token(TokenKind.INSTANCEOF, this.startpos, this.endpos);
    }

    public Token asMatchesToken() {
        return new Token(TokenKind.MATCHES, this.startpos, this.endpos);
    }

    public Token asBetweenToken() {
        return new Token(TokenKind.BETWEEN, this.startpos, this.endpos);
    }
}

