/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import org.springframework.expression.EvaluationException;
import org.springframework.expression.Operation;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.ast.Operator;
import org.springframework.expression.spel.ast.SpelNodeImpl;

public class OperatorPower
extends Operator {
    public OperatorPower(int pos, SpelNodeImpl ... operands) {
        super("^", pos, operands);
    }

    public TypedValue getValueInternal(ExpressionState state) throws EvaluationException {
        SpelNodeImpl leftOp = this.getLeftOperand();
        SpelNodeImpl rightOp = this.getRightOperand();
        Object operandOne = leftOp.getValueInternal(state).getValue();
        Object operandTwo = rightOp.getValueInternal(state).getValue();
        if (operandOne instanceof Number && operandTwo instanceof Number) {
            Number op1 = (Number)operandOne;
            Number op2 = (Number)operandTwo;
            if (op1 instanceof Double || op2 instanceof Double) {
                return new TypedValue(Math.pow(op1.doubleValue(), op2.doubleValue()));
            }
            if (op1 instanceof Long || op2 instanceof Long) {
                double d2 = Math.pow(op1.longValue(), op2.longValue());
                return new TypedValue((long)d2);
            }
            double d3 = Math.pow(op1.longValue(), op2.longValue());
            if (d3 > 2.147483647E9) {
                return new TypedValue((long)d3);
            }
            return new TypedValue((int)d3);
        }
        return state.operate(Operation.POWER, operandOne, operandTwo);
    }
}

