/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.SpelNode;
import org.springframework.expression.spel.ast.Literal;
import org.springframework.expression.spel.ast.SpelNodeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InlineList
extends SpelNodeImpl {
    TypedValue constant = null;

    public InlineList(int pos, SpelNodeImpl ... args) {
        super(pos, args);
        this.checkIfConstant();
    }

    private void checkIfConstant() {
        boolean isConstant = true;
        int c2 = 0;
        int max = this.getChildCount();
        while (c2 < max) {
            SpelNode child = this.getChild(c2);
            if (!(child instanceof Literal)) {
                if (child instanceof InlineList) {
                    InlineList inlineList = (InlineList)child;
                    if (!inlineList.isConstant()) {
                        isConstant = false;
                    }
                } else {
                    isConstant = false;
                }
            }
            ++c2;
        }
        if (isConstant) {
            ArrayList<Object> constantList = new ArrayList<Object>();
            int childcount = this.getChildCount();
            int c3 = 0;
            while (c3 < childcount) {
                SpelNode child = this.getChild(c3);
                if (child instanceof Literal) {
                    constantList.add(((Literal)child).getLiteralValue().getValue());
                } else if (child instanceof InlineList) {
                    constantList.add(((InlineList)child).getConstantValue());
                }
                ++c3;
            }
            this.constant = new TypedValue(Collections.unmodifiableList(constantList), TypeDescriptor.valueOf(List.class));
        }
    }

    @Override
    public TypedValue getValueInternal(ExpressionState expressionState) throws EvaluationException {
        if (this.constant != null) {
            return this.constant;
        }
        ArrayList<Object> returnValue = new ArrayList<Object>();
        int childcount = this.getChildCount();
        int c2 = 0;
        while (c2 < childcount) {
            returnValue.add(this.getChild(c2).getValue(expressionState));
            ++c2;
        }
        return new TypedValue(returnValue, TypeDescriptor.valueOf(List.class));
    }

    @Override
    public String toStringAST() {
        StringBuilder s2 = new StringBuilder();
        s2.append('{');
        int count = this.getChildCount();
        int c2 = 0;
        while (c2 < count) {
            if (c2 > 0) {
                s2.append(',');
            }
            s2.append(this.getChild(c2).toStringAST());
            ++c2;
        }
        s2.append('}');
        return s2.toString();
    }

    public boolean isConstant() {
        return this.constant != null;
    }

    private List<Object> getConstantValue() {
        return (List)this.constant.getValue();
    }
}

