/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.statistics;

import java.util.List;
import org.jfree.data.KeyedObjects2D;
import org.jfree.data.Range;
import org.jfree.data.RangeInfo;
import org.jfree.data.general.AbstractDataset;
import org.jfree.data.statistics.MeanAndStandardDeviation;
import org.jfree.data.statistics.StatisticalCategoryDataset;
import org.jfree.util.PublicCloneable;

public class DefaultStatisticalCategoryDataset
extends AbstractDataset
implements StatisticalCategoryDataset,
RangeInfo,
PublicCloneable {
    private KeyedObjects2D data = new KeyedObjects2D();
    private double minimumRangeValue = Double.NaN;
    private int minimumRangeValueRow = -1;
    private int minimumRangeValueColumn = -1;
    private double minimumRangeValueIncStdDev;
    private int minimumRangeValueIncStdDevRow = -1;
    private int minimumRangeValueIncStdDevColumn = -1;
    private double maximumRangeValue = Double.NaN;
    private int maximumRangeValueRow = -1;
    private int maximumRangeValueColumn = -1;
    private double maximumRangeValueIncStdDev;
    private int maximumRangeValueIncStdDevRow = -1;
    private int maximumRangeValueIncStdDevColumn = -1;

    public DefaultStatisticalCategoryDataset() {
        this.minimumRangeValueIncStdDev = Double.NaN;
        this.maximumRangeValueIncStdDev = Double.NaN;
    }

    @Override
    public Number getMeanValue(int row, int column) {
        Number result = null;
        MeanAndStandardDeviation masd = (MeanAndStandardDeviation)this.data.getObject(row, column);
        if (masd != null) {
            result = masd.getMean();
        }
        return result;
    }

    @Override
    public Number getValue(int row, int column) {
        return this.getMeanValue(row, column);
    }

    @Override
    public Number getValue(Comparable rowKey, Comparable columnKey) {
        return this.getMeanValue(rowKey, columnKey);
    }

    @Override
    public Number getMeanValue(Comparable rowKey, Comparable columnKey) {
        Number result = null;
        MeanAndStandardDeviation masd = (MeanAndStandardDeviation)this.data.getObject(rowKey, columnKey);
        if (masd != null) {
            result = masd.getMean();
        }
        return result;
    }

    @Override
    public Number getStdDevValue(int row, int column) {
        Number result = null;
        MeanAndStandardDeviation masd = (MeanAndStandardDeviation)this.data.getObject(row, column);
        if (masd != null) {
            result = masd.getStandardDeviation();
        }
        return result;
    }

    @Override
    public Number getStdDevValue(Comparable rowKey, Comparable columnKey) {
        Number result = null;
        MeanAndStandardDeviation masd = (MeanAndStandardDeviation)this.data.getObject(rowKey, columnKey);
        if (masd != null) {
            result = masd.getStandardDeviation();
        }
        return result;
    }

    @Override
    public int getColumnIndex(Comparable key) {
        return this.data.getColumnIndex(key);
    }

    @Override
    public Comparable getColumnKey(int column) {
        return this.data.getColumnKey(column);
    }

    @Override
    public List getColumnKeys() {
        return this.data.getColumnKeys();
    }

    @Override
    public int getRowIndex(Comparable key) {
        return this.data.getRowIndex(key);
    }

    @Override
    public Comparable getRowKey(int row) {
        return this.data.getRowKey(row);
    }

    @Override
    public List getRowKeys() {
        return this.data.getRowKeys();
    }

    @Override
    public int getRowCount() {
        return this.data.getRowCount();
    }

    @Override
    public int getColumnCount() {
        return this.data.getColumnCount();
    }

    public void add(double mean, double standardDeviation, Comparable rowKey, Comparable columnKey) {
        this.add(new Double(mean), new Double(standardDeviation), rowKey, columnKey);
    }

    public void add(Number mean, Number standardDeviation, Comparable rowKey, Comparable columnKey) {
        MeanAndStandardDeviation item = new MeanAndStandardDeviation(mean, standardDeviation);
        this.data.addObject(item, rowKey, columnKey);
        double m2 = Double.NaN;
        double sd = Double.NaN;
        if (mean != null) {
            m2 = mean.doubleValue();
        }
        if (standardDeviation != null) {
            sd = standardDeviation.doubleValue();
        }
        int r2 = this.data.getColumnIndex(columnKey);
        int c2 = this.data.getRowIndex(rowKey);
        if (r2 == this.maximumRangeValueRow && c2 == this.maximumRangeValueColumn || r2 == this.maximumRangeValueIncStdDevRow && c2 == this.maximumRangeValueIncStdDevColumn || r2 == this.minimumRangeValueRow && c2 == this.minimumRangeValueColumn || r2 == this.minimumRangeValueIncStdDevRow && c2 == this.minimumRangeValueIncStdDevColumn) {
            this.updateBounds();
        } else {
            if (!Double.isNaN(m2) && (Double.isNaN(this.maximumRangeValue) || m2 > this.maximumRangeValue)) {
                this.maximumRangeValue = m2;
                this.maximumRangeValueRow = r2;
                this.maximumRangeValueColumn = c2;
            }
            if (!Double.isNaN(m2 + sd) && (Double.isNaN(this.maximumRangeValueIncStdDev) || m2 + sd > this.maximumRangeValueIncStdDev)) {
                this.maximumRangeValueIncStdDev = m2 + sd;
                this.maximumRangeValueIncStdDevRow = r2;
                this.maximumRangeValueIncStdDevColumn = c2;
            }
            if (!Double.isNaN(m2) && (Double.isNaN(this.minimumRangeValue) || m2 < this.minimumRangeValue)) {
                this.minimumRangeValue = m2;
                this.minimumRangeValueRow = r2;
                this.minimumRangeValueColumn = c2;
            }
            if (!Double.isNaN(m2 - sd) && (Double.isNaN(this.minimumRangeValueIncStdDev) || m2 - sd < this.minimumRangeValueIncStdDev)) {
                this.minimumRangeValueIncStdDev = m2 - sd;
                this.minimumRangeValueIncStdDevRow = r2;
                this.minimumRangeValueIncStdDevColumn = c2;
            }
        }
        this.fireDatasetChanged();
    }

    public void remove(Comparable rowKey, Comparable columnKey) {
        int r2 = this.getRowIndex(rowKey);
        int c2 = this.getColumnIndex(columnKey);
        this.data.removeObject(rowKey, columnKey);
        if (r2 == this.maximumRangeValueRow && c2 == this.maximumRangeValueColumn || r2 == this.maximumRangeValueIncStdDevRow && c2 == this.maximumRangeValueIncStdDevColumn || r2 == this.minimumRangeValueRow && c2 == this.minimumRangeValueColumn || r2 == this.minimumRangeValueIncStdDevRow && c2 == this.minimumRangeValueIncStdDevColumn) {
            this.updateBounds();
        }
        this.fireDatasetChanged();
    }

    public void removeRow(int rowIndex) {
        this.data.removeRow(rowIndex);
        this.updateBounds();
        this.fireDatasetChanged();
    }

    public void removeRow(Comparable rowKey) {
        this.data.removeRow(rowKey);
        this.updateBounds();
        this.fireDatasetChanged();
    }

    public void removeColumn(int columnIndex) {
        this.data.removeColumn(columnIndex);
        this.updateBounds();
        this.fireDatasetChanged();
    }

    public void removeColumn(Comparable columnKey) {
        this.data.removeColumn(columnKey);
        this.updateBounds();
        this.fireDatasetChanged();
    }

    public void clear() {
        this.data.clear();
        this.updateBounds();
        this.fireDatasetChanged();
    }

    private void updateBounds() {
        this.maximumRangeValue = Double.NaN;
        this.maximumRangeValueRow = -1;
        this.maximumRangeValueColumn = -1;
        this.minimumRangeValue = Double.NaN;
        this.minimumRangeValueRow = -1;
        this.minimumRangeValueColumn = -1;
        this.maximumRangeValueIncStdDev = Double.NaN;
        this.maximumRangeValueIncStdDevRow = -1;
        this.maximumRangeValueIncStdDevColumn = -1;
        this.minimumRangeValueIncStdDev = Double.NaN;
        this.minimumRangeValueIncStdDevRow = -1;
        this.minimumRangeValueIncStdDevColumn = -1;
        int rowCount = this.data.getRowCount();
        int columnCount = this.data.getColumnCount();
        for (int r2 = 0; r2 < rowCount; ++r2) {
            for (int c2 = 0; c2 < columnCount; ++c2) {
                MeanAndStandardDeviation masd = (MeanAndStandardDeviation)this.data.getObject(r2, c2);
                if (masd == null) continue;
                double m2 = masd.getMeanValue();
                double sd = masd.getStandardDeviationValue();
                if (Double.isNaN(m2)) continue;
                if (Double.isNaN(this.maximumRangeValue)) {
                    this.maximumRangeValue = m2;
                    this.maximumRangeValueRow = r2;
                    this.maximumRangeValueColumn = c2;
                } else if (m2 > this.maximumRangeValue) {
                    this.maximumRangeValue = m2;
                    this.maximumRangeValueRow = r2;
                    this.maximumRangeValueColumn = c2;
                }
                if (Double.isNaN(this.minimumRangeValue)) {
                    this.minimumRangeValue = m2;
                    this.minimumRangeValueRow = r2;
                    this.minimumRangeValueColumn = c2;
                } else if (m2 < this.minimumRangeValue) {
                    this.minimumRangeValue = m2;
                    this.minimumRangeValueRow = r2;
                    this.minimumRangeValueColumn = c2;
                }
                if (Double.isNaN(sd)) continue;
                if (Double.isNaN(this.maximumRangeValueIncStdDev)) {
                    this.maximumRangeValueIncStdDev = m2 + sd;
                    this.maximumRangeValueIncStdDevRow = r2;
                    this.maximumRangeValueIncStdDevColumn = c2;
                } else if (m2 + sd > this.maximumRangeValueIncStdDev) {
                    this.maximumRangeValueIncStdDev = m2 + sd;
                    this.maximumRangeValueIncStdDevRow = r2;
                    this.maximumRangeValueIncStdDevColumn = c2;
                }
                if (Double.isNaN(this.minimumRangeValueIncStdDev)) {
                    this.minimumRangeValueIncStdDev = m2 - sd;
                    this.minimumRangeValueIncStdDevRow = r2;
                    this.minimumRangeValueIncStdDevColumn = c2;
                    continue;
                }
                if (!(m2 - sd < this.minimumRangeValueIncStdDev)) continue;
                this.minimumRangeValueIncStdDev = m2 - sd;
                this.minimumRangeValueIncStdDevRow = r2;
                this.minimumRangeValueIncStdDevColumn = c2;
            }
        }
    }

    @Override
    public double getRangeLowerBound(boolean includeInterval) {
        if (includeInterval && !Double.isNaN(this.minimumRangeValueIncStdDev)) {
            return this.minimumRangeValueIncStdDev;
        }
        return this.minimumRangeValue;
    }

    @Override
    public double getRangeUpperBound(boolean includeInterval) {
        if (includeInterval && !Double.isNaN(this.maximumRangeValueIncStdDev)) {
            return this.maximumRangeValueIncStdDev;
        }
        return this.maximumRangeValue;
    }

    @Override
    public Range getRangeBounds(boolean includeInterval) {
        double lower = this.getRangeLowerBound(includeInterval);
        double upper = this.getRangeUpperBound(includeInterval);
        if (Double.isNaN(lower) && Double.isNaN(upper)) {
            return null;
        }
        return new Range(lower, upper);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DefaultStatisticalCategoryDataset)) {
            return false;
        }
        DefaultStatisticalCategoryDataset that = (DefaultStatisticalCategoryDataset)obj;
        return this.data.equals(that.data);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DefaultStatisticalCategoryDataset clone = (DefaultStatisticalCategoryDataset)super.clone();
        clone.data = (KeyedObjects2D)this.data.clone();
        return clone;
    }
}

