/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.springtools.web.widgets;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import org.homelinux.elabor.springtools.web.widgets.Message;
import org.homelinux.elabor.springtools.web.widgets.Sentence;
import org.springframework.context.MessageSource;

public class TalkManager
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static DateFormat FULL_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,S");
    private static final String SEPARATOR = ";";
    private Locale locale;
    private MessageSource messageSource;
    private List<Sentence> sentences;
    private Logger logger;

    public TalkManager() {
        this(Logger.getAnonymousLogger());
    }

    public TalkManager(Logger logger) {
        this.flushSentences();
        this.setLogger(logger);
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void flushSentences() {
        this.sentences = new ArrayList<Sentence>();
    }

    public void addSentence(Sentence sentence) {
        if (!this.sentences.add(sentence)) {
            throw new RuntimeException("sentence non aggiunta");
        }
        this.log(sentence);
    }

    public void addSentence(Sentence sentence, Writer writer) {
        if (!this.sentences.add(sentence)) {
            throw new RuntimeException("sentence non aggiunta");
        }
        this.logImport(sentence, writer);
    }

    public void log() {
        for (Sentence sentence : this.sentences) {
            this.log(sentence);
        }
        this.flushSentences();
    }

    public void log(Sentence sentence) {
        if (this.locale != null && this.messageSource != null) {
            String description = sentence.getDescription();
            List<String> params = sentence.getParams();
            String messageBody = this.getMessage(description, params);
            String title = sentence.getTitle();
            String messageTitle = this.getMessage(title, params);
            this.logger.info(String.valueOf(messageTitle) + ": " + messageBody);
        }
    }

    public String getTitle(Sentence sentence) {
        String title = sentence.getTitle();
        List<String> params = sentence.getParams();
        return this.getMessage(title, params);
    }

    public String getMessage(Sentence sentence) {
        String description = sentence.getDescription();
        List<String> params = sentence.getParams();
        return this.getMessage(description, params);
    }

    private String getMessage(String description, List<String> params) {
        Object[] array = params.toArray();
        return this.messageSource == null ? description : this.messageSource.getMessage(description, array, description, this.locale);
    }

    @Deprecated
    private void logImport(Sentence sentence, Writer writer) {
        if (this.locale != null && this.messageSource != null) {
            String message = this.messageSource.getMessage(sentence.getDescription(), sentence.getParams().toArray(), "???" + sentence.getDescription() + "???", this.locale);
            String title = this.messageSource.getMessage(sentence.getTitle(), null, "???" + sentence.getTitle() + "???", this.locale);
            this.logger.info(String.valueOf(title) + ": " + message);
            try {
                Date d2 = new Date();
                d2.getTime();
                writer.write(String.valueOf(FULL_DATE_FORMAT.format(d2)) + SEPARATOR + "\"" + this.logger.getParent().getLevel() + "\"" + SEPARATOR + "\"" + title + "\"" + SEPARATOR + "\"" + message + "\"" + "\n");
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
    }

    public void addSentences(Collection<Sentence> sentenceList) {
        for (Sentence sentence : sentenceList) {
            this.addSentence(sentence);
        }
    }

    public void addSentence(String title, String description) {
        Message message = new Message(title, description);
        this.addSentence(message);
    }

    public List<Sentence> getSentencesNoFlush() {
        return this.sentences;
    }

    public Map<String, List<Sentence>> getSentencesMap() {
        LinkedHashMap<String, List<Sentence>> map = new LinkedHashMap<String, List<Sentence>>();
        for (Sentence sentence : this.getSentences()) {
            String key = sentence.getTitle();
            ArrayList<Sentence> list = (ArrayList<Sentence>)map.get(key);
            if (list == null) {
                list = new ArrayList<Sentence>();
                map.put(key, list);
            }
            list.add(sentence);
        }
        return map;
    }

    public List<Sentence> getSentences() {
        List<Sentence> current = this.sentences;
        this.flushSentences();
        return current;
    }

    public int getSize() {
        return this.sentences.size();
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public Logger getLogger() {
        return this.logger;
    }
}

