/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.springtools.web.controllers;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import org.homelinux.elabor.springtools.web.check.EmptyParameterValue;
import org.homelinux.elabor.springtools.web.check.InvalidParameterValue;
import org.homelinux.elabor.springtools.web.check.ParameterNotFoundException;
import org.homelinux.elabor.springtools.web.controllers.FileAlreadyExistsException;
import org.springframework.web.multipart.MultipartFile;

public class FileSystemHelper {
    public static File getFile(File uploadFolder, String name) {
        String fileName;
        try {
            fileName = URLEncoder.encode(name, "UTF8");
        }
        catch (UnsupportedEncodingException exc) {
            throw new RuntimeException(exc);
        }
        return new File(uploadFolder, fileName);
    }

    public static String uploadOriginalFile(File uploadFolder, String name, Map<String, Object> paramMap) throws ParameterNotFoundException, EmptyParameterValue, InvalidParameterValue, IOException, FileAlreadyExistsException {
        MultipartFile mpf = FileSystemHelper.getUploadFileParam(name, paramMap, "");
        String originalName = mpf.getOriginalFilename();
        File file = FileSystemHelper.getFile(uploadFolder, originalName);
        if (file.exists()) {
            throw new FileAlreadyExistsException(file);
        }
        try {
            mpf.transferTo(file);
        }
        catch (RuntimeException exc) {
            exc.printStackTrace();
            throw new InvalidParameterValue(name, paramMap.get(name).toString());
        }
        return originalName;
    }

    public static void uploadFile(File file, String name, Map<String, Object> paramMap) throws ParameterNotFoundException, InvalidParameterValue, IOException, FileAlreadyExistsException, EmptyParameterValue {
        MultipartFile mpf = FileSystemHelper.checkUploadPdfFile(file, name, paramMap);
        try {
            mpf.transferTo(file);
        }
        catch (RuntimeException exc) {
            exc.printStackTrace();
            throw new InvalidParameterValue(name, paramMap.get(name).toString());
        }
    }

    public static void uploadOverwriteFile(File file, String name, Map<String, Object> paramMap) throws ParameterNotFoundException, InvalidParameterValue, IOException, EmptyParameterValue {
        MultipartFile mpf = FileSystemHelper.checkUploadOverwritePdfFile(name, paramMap);
        try {
            mpf.transferTo(file);
        }
        catch (RuntimeException exc) {
            exc.printStackTrace();
            throw new InvalidParameterValue(name, paramMap.get(name).toString());
        }
    }

    public static void uploadOverwriteFile(File file, String name, Map<String, Object> paramMap, String extension) throws ParameterNotFoundException, InvalidParameterValue, IOException, EmptyParameterValue {
        MultipartFile mpf = FileSystemHelper.getUploadFileParam(name, paramMap, extension);
        try {
            mpf.transferTo(file);
        }
        catch (RuntimeException exc) {
            exc.printStackTrace();
            throw new InvalidParameterValue(name, paramMap.get(name).toString());
        }
    }

    public static MultipartFile checkUploadOverwritePdfFile(String name, Map<String, Object> paramMap) throws ParameterNotFoundException, EmptyParameterValue, InvalidParameterValue {
        MultipartFile mpf = FileSystemHelper.getUploadFileParam(name, paramMap, ".pdf");
        return mpf;
    }

    public static MultipartFile checkUploadPdfFile(File file, String name, Map<String, Object> paramMap) throws ParameterNotFoundException, EmptyParameterValue, InvalidParameterValue, FileAlreadyExistsException {
        MultipartFile mpf = FileSystemHelper.getUploadFileParam(name, paramMap, ".pdf");
        if (file.exists()) {
            throw new FileAlreadyExistsException(file);
        }
        return mpf;
    }

    public static MultipartFile getUploadFileParam(String name, Map<String, Object> paramMap, String extension) throws ParameterNotFoundException, EmptyParameterValue, InvalidParameterValue {
        Object object = paramMap.get(name);
        if (object == null) {
            throw new ParameterNotFoundException(name);
        }
        MultipartFile mpf = (MultipartFile)((List)object).get(0);
        String fileName = mpf.getOriginalFilename();
        if (fileName.isEmpty()) {
            throw new EmptyParameterValue(name);
        }
        if (!fileName.toLowerCase().endsWith(extension)) {
            throw new InvalidParameterValue(name, fileName);
        }
        return mpf;
    }

    public static MultipartFile checkFile(String name, Map<String, Object> paramMap) throws ParameterNotFoundException, EmptyParameterValue {
        Object object = paramMap.get(name);
        if (object == null) {
            throw new ParameterNotFoundException(name);
        }
        MultipartFile mpf = (MultipartFile)((List)object).get(0);
        String fileName = mpf.getOriginalFilename();
        if (fileName.isEmpty()) {
            throw new EmptyParameterValue(name);
        }
        return mpf;
    }

    public static void deleteFiles(File folder, List<String> fileNames) {
        FileSystemHelper.deleteFiles(folder, fileNames, "");
    }

    public static void deleteFiles(File folder, List<String> fileNames, String suffix) {
        for (String fileName : fileNames) {
            String fileNameSuffix = String.valueOf(fileName) + suffix;
            FileSystemHelper.deleteFile(folder, fileNameSuffix);
        }
    }

    public static void deleteFile(File folder, String fileName) {
        File file = FileSystemHelper.getFile(folder, fileName);
        file.delete();
    }

    public static String getFileName(String name, Map<String, Object> paramMap) {
        String fileName;
        try {
            MultipartFile mpf = FileSystemHelper.checkFile(name, paramMap);
            fileName = mpf.getOriginalFilename();
        }
        catch (ParameterNotFoundException e2) {
            fileName = null;
        }
        catch (EmptyParameterValue e3) {
            fileName = null;
        }
        return fileName;
    }
}

