/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.springtools.services;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;

class Thumbnail {
    Thumbnail() {
    }

    public static byte[] createThumbArray(byte[] data, Integer thumbWidth, Integer thumbHeight) throws Exception {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        Thumbnail.createThumb(data, (int)thumbWidth, (int)thumbHeight, (OutputStream)result);
        return result.toByteArray();
    }

    public static void createThumb(byte[] data, int thumbWidth, int thumbHeight, OutputStream out) throws Exception {
        Image image = Toolkit.getDefaultToolkit().createImage(data);
        MediaTracker mediaTracker = new MediaTracker(new Panel());
        int trackID = 0;
        mediaTracker.addImage(image, trackID);
        mediaTracker.waitForID(trackID);
        if (image.getWidth(null) <= thumbWidth && image.getHeight(null) <= thumbHeight) {
            out.write(data);
        } else {
            Thumbnail.createThumb(image, thumbWidth, thumbHeight, out);
        }
    }

    public static BufferedImage drawSquareCrop(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        int length = Math.min(width, height);
        int delta = Math.abs(width - height) / 2;
        BufferedImage thumbImage = new BufferedImage(length, length, 1);
        Graphics2D graphics2D = thumbImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        if (width > height) {
            graphics2D.drawImage(image.getSubimage(delta, 0, length, length), 0, 0, length, length, null);
        } else {
            graphics2D.drawImage(image.getSubimage(0, delta, length, length), 0, 0, length, length, null);
        }
        return thumbImage;
    }

    public static BufferedImage drawThumbnail(BufferedImage image, int tWidth, int tHeight) {
        int imageHeight;
        int thumbWidth = tWidth;
        int thumbHeight = tHeight;
        double thumbRatio = (double)thumbWidth / (double)thumbHeight;
        int imageWidth = image.getWidth(null);
        double imageRatio = (double)imageWidth / (double)(imageHeight = image.getHeight(null));
        if (thumbRatio < imageRatio) {
            thumbHeight = (int)((double)thumbWidth / imageRatio);
        } else {
            thumbWidth = (int)((double)thumbHeight * imageRatio);
        }
        BufferedImage thumbImage = new BufferedImage(thumbWidth, thumbHeight, 1);
        Graphics2D graphics2D = thumbImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.drawImage(image, 0, 0, thumbWidth, thumbHeight, null);
        return thumbImage;
    }

    public static BufferedImage drawImage(Image image) {
        BufferedImage thumbImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
        Graphics2D graphics2D = thumbImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.drawImage(image, 0, 0, image.getWidth(null), image.getHeight(null), null);
        return thumbImage;
    }

    public static void createThumb(Image image, int thumbWidth, int thumbHeight, OutputStream out) throws Exception {
        BufferedImage thumbImage = Thumbnail.drawImage(image);
        thumbImage = Thumbnail.drawSquareCrop(thumbImage);
        thumbImage = Thumbnail.drawThumbnail(thumbImage, thumbWidth, thumbHeight);
        ImageIO.write((RenderedImage)thumbImage, "jpeg", out);
    }
}

