/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.springtools.dao.jdbc;

import java.util.List;
import org.homelinux.elabor.springtools.dao.GeoDao;
import org.homelinux.elabor.springtools.domain.locations.Comune;
import org.homelinux.elabor.springtools.domain.locations.Nazione;
import org.homelinux.elabor.springtools.domain.locations.Provincia;
import org.homelinux.elabor.springtools.domain.locations.Regione;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcDaoSupport;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.orm.ObjectRetrievalFailureException;

public class JdbcGeoDao
extends SimpleJdbcDaoSupport
implements GeoDao {
    private static final String GET_REGIONE = "SELECT * FROM regioni WHERE id = ?";
    private static final String GET_REGIONI = "SELECT * FROM regioni ORDER BY descrizione";
    private static final String GET_PROVINCIA = "SELECT province.*, regioni.descrizione AS regione FROM province, regioni WHERE province.id = ? AND province.id_regione = regioni.id";
    private static final String GET_PROVINCIA_BY_NAME = "SELECT province.*, regioni.descrizione AS regione FROM province, regioni WHERE province.descrizione = ? AND province.id_regione = regioni.id";
    private static final String GET_PROVINCE = "SELECT province.*, regioni.descrizione AS regione FROM province, regioni WHERE province.id_regione = regioni.id ORDER BY province.descrizione";
    private static final String GET_PROVINCE_BY_REGIONE = "SELECT province.*, regioni.descrizione AS regione FROM province, regioni WHERE province.id_regione = regioni.id AND regioni.id = ? ORDER BY province.descrizione";
    private static final String GET_COMUNE = "SELECT comuni.*, province.descrizione AS provincia, regioni.descrizione AS regione FROM comuni, province, regioni WHERE comuni.id = ? AND comuni.id_provincia = province.id AND province.id_regione = regioni.id";
    private static final String GET_COMUNI = "SELECT comuni.*, province.descrizione AS provincia, regioni.descrizione AS regione FROM comuni, province, regioni WHERE comuni.id_provincia = province.id AND province.id_regione = regioni.id";
    private static final String GET_COMUNI_BY_PROVINCIA = "SELECT comuni.*, province.descrizione AS provincia, regioni.descrizione AS regione FROM comuni, province, regioni WHERE comuni.id_provincia = ? AND comuni.id_provincia = province.id AND province.id_regione = regioni.id ORDER BY comuni.descrizione";
    private static final String GET_COUNTRY = "SELECT id, descrizione, ISO2 AS sigla, ISON as codice, capitale, moneta, codice_moneta FROM nazioni WHERE id = ?";
    private static final String GET_COUNTRIES = "SELECT id, descrizione, ISO2 AS sigla, ISON as codice, capitale, moneta, codice_moneta FROM nazioni ORDER BY descrizione";

    @Override
    public Regione loadRegione(int idRegione) {
        BeanPropertyRowMapper<Regione> newInstance = BeanPropertyRowMapper.newInstance(Regione.class);
        return this.getSimpleJdbcTemplate().queryForObject(GET_REGIONE, newInstance, new Integer(idRegione));
    }

    @Override
    public List<Regione> loadRegioni() {
        return this.getSimpleJdbcTemplate().query(GET_REGIONI, BeanPropertyRowMapper.newInstance(Regione.class), new Object[0]);
    }

    @Override
    public Provincia loadProvincia(int idProvincia) {
        BeanPropertyRowMapper<Provincia> newInstance = BeanPropertyRowMapper.newInstance(Provincia.class);
        return this.getSimpleJdbcTemplate().queryForObject(GET_PROVINCIA, newInstance, new Integer(idProvincia));
    }

    @Override
    public Provincia loadProvincia(String descrizione) {
        BeanPropertyRowMapper<Provincia> newInstance = BeanPropertyRowMapper.newInstance(Provincia.class);
        return this.getSimpleJdbcTemplate().queryForObject(GET_PROVINCIA_BY_NAME, newInstance, descrizione);
    }

    @Override
    public List<Provincia> loadProvince() {
        return this.getSimpleJdbcTemplate().query(GET_PROVINCE, BeanPropertyRowMapper.newInstance(Provincia.class), new Object[0]);
    }

    @Override
    public List<Provincia> loadProvince(int idRegione) {
        BeanPropertyRowMapper<Provincia> newInstance = BeanPropertyRowMapper.newInstance(Provincia.class);
        return this.getSimpleJdbcTemplate().query(GET_PROVINCE_BY_REGIONE, newInstance, new Integer(idRegione));
    }

    @Override
    public Comune loadComune(int idComune) {
        BeanPropertyRowMapper<Comune> newInstance = BeanPropertyRowMapper.newInstance(Comune.class);
        return this.getSimpleJdbcTemplate().queryForObject(GET_COMUNE, newInstance, new Integer(idComune));
    }

    @Override
    public List<Comune> loadComuni() {
        return this.getSimpleJdbcTemplate().query(GET_COMUNI, BeanPropertyRowMapper.newInstance(Comune.class), new Object[0]);
    }

    @Override
    public List<Comune> loadComuni(int idProvincia) {
        BeanPropertyRowMapper<Comune> newInstance = BeanPropertyRowMapper.newInstance(Comune.class);
        return this.getSimpleJdbcTemplate().query(GET_COMUNI_BY_PROVINCIA, newInstance, new Integer(idProvincia));
    }

    @Override
    public Nazione loadNazione(int nazioneId) {
        Nazione country;
        SimpleJdbcTemplate template = this.getSimpleJdbcTemplate();
        try {
            BeanPropertyRowMapper<Nazione> newInstance = BeanPropertyRowMapper.newInstance(Nazione.class);
            country = template.queryForObject(GET_COUNTRY, newInstance, new Integer(nazioneId));
        }
        catch (EmptyResultDataAccessException ex) {
            throw new ObjectRetrievalFailureException(Nazione.class, (Object)new Integer(nazioneId));
        }
        return country;
    }

    @Override
    public List<Nazione> loadNazioni() {
        return this.getSimpleJdbcTemplate().query(GET_COUNTRIES, BeanPropertyRowMapper.newInstance(Nazione.class), new Object[0]);
    }
}

