/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.print;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.util.List;
import org.homelinux.elabor.print.BrotherPrinter;

class BrotherPainter
implements Printable {
    private String barcode;
    private List<String> values;

    public BrotherPainter(String barcode, List<String> values) {
        this.barcode = barcode;
        this.values = values;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) {
        int retValue;
        if (pageIndex < 1) {
            Graphics2D g2d = (Graphics2D)graphics;
            Font font = g2d.getFont();
            font = font.deriveFont(9.0f);
            g2d.setFont(font);
            double imageableX = pageFormat.getImageableX();
            double imageableY = pageFormat.getImageableY();
            g2d.translate(imageableX, imageableY);
            Image image = BrotherPrinter.buildBarcodeImage(this.barcode);
            int index = 0;
            for (String value : this.values) {
                g2d.drawString(value, 5, 20 + 9 * index);
                ++index;
            }
            g2d.drawImage(image, 5, 1, null);
            retValue = 0;
        } else {
            retValue = 1;
        }
        return retValue;
    }
}

