/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.file;

import java.io.File;
import java.io.FilenameFilter;
import javax.swing.filechooser.FileFilter;

public class ExtensionFileFilter
extends FileFilter
implements FilenameFilter {
    private final String[] extensions;
    private final String description;
    private final boolean acceptFolders;

    public ExtensionFileFilter(String extension, String description) {
        this(new String[]{extension}, description, true);
    }

    public ExtensionFileFilter(String extension, String description, boolean acceptFolders) {
        this(new String[]{extension}, description, acceptFolders);
    }

    public ExtensionFileFilter(String[] extensions, String description) {
        this(extensions, description, true);
    }

    public ExtensionFileFilter(String[] extensions, String description, boolean acceptFolders) {
        this.extensions = extensions;
        this.description = description;
        this.acceptFolders = acceptFolders;
    }

    @Override
    public boolean accept(File file) {
        boolean ok = this.acceptFolders && file.isDirectory();
        String name = file.getName().toLowerCase();
        int size = this.extensions.length;
        int index = 0;
        while (!ok && index < size) {
            String extension = this.extensions[index].toLowerCase();
            ok = name.endsWith(extension);
            ++index;
        }
        return ok;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean accept(File dir, String name) {
        File file = new File(dir, name);
        return this.accept(file);
    }
}

