/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.email;

import java.util.List;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.homelinux.elabor.email.EmailHandler;

public class SimpleRecipientsEmailHandler
implements EmailHandler {
    private final Message.RecipientType type;
    private final Address[] addresses;

    public SimpleRecipientsEmailHandler(Message.RecipientType type, InternetAddress address) {
        this.type = type;
        this.addresses = new Address[1];
        this.addresses[0] = address;
    }

    public SimpleRecipientsEmailHandler(Message.RecipientType type, List<InternetAddress> addresses) {
        this.type = type;
        this.addresses = addresses.toArray(new InternetAddress[addresses.size()]);
    }

    public SimpleRecipientsEmailHandler(Message.RecipientType type, String[] emailAddresses) throws AddressException {
        this.type = type;
        this.addresses = new InternetAddress[emailAddresses.length];
        int index = 0;
        while (index < emailAddresses.length) {
            this.addresses[index] = new InternetAddress(emailAddresses[index], true);
            ++index;
        }
    }

    @Override
    public void handle(MimeMessage message) throws MessagingException {
        message.addRecipients(this.type, this.addresses);
    }
}

