/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.db.generic;

import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.homelinux.elabor.db.ConnectionHandler;
import org.homelinux.elabor.db.DataAccessException;
import org.homelinux.elabor.db.DataNotFoundException;
import org.homelinux.elabor.db.QueryTemplate;
import org.homelinux.elabor.db.RecordCreator;
import org.homelinux.elabor.db.generic.GenericRecordCreator;

public class GenericDao {
    private ConnectionHandler manager;

    public GenericDao(ConnectionHandler manager) {
        this.manager = manager;
    }

    public <T> List<T> getRecords(QueryTemplate query, Class<T> recordClass) {
        RecordCreator<T> creator = this.buildCreator(recordClass);
        return this.getRecords(query, creator);
    }

    public <T> List<T> getRecords(QueryTemplate query, RecordCreator<T> creator) {
        return this.getRecords(query.toString(), creator);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T> List<T> getRecords(String query, RecordCreator<T> creator) {
        ArrayList<T> list = new ArrayList<T>();
        Connection connection = this.manager.getConnection();
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try {
                Statement statement = connection.createStatement(1004, 1008);
                try {
                    try (ResultSet rs = this.manager.executeQuery(query, statement);){
                        while (rs.next()) {
                            T record = creator.createRecord(rs);
                            list.add(record);
                        }
                    }
                    if (statement == null) return list;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (statement == null) throw throwable;
                    statement.close();
                    throw throwable;
                }
                statement.close();
                return list;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (SQLException e2) {
            throw new DataAccessException(e2);
        }
    }

    public <T> T getRecord(QueryTemplate query, Class<T> recordClass) throws DataNotFoundException {
        RecordCreator<T> creator = this.buildCreator(recordClass);
        return this.getRecord(query, creator);
    }

    public <T> T getRecord(QueryTemplate query, RecordCreator<T> creator) throws DataNotFoundException {
        return this.getRecord(query.toString(), creator, "", "", true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T> T getRecord(String query, RecordCreator<T> creator, String tableName, String key, boolean checkUnique) throws DataNotFoundException {
        Connection connection = this.manager.getConnection();
        try {
            Throwable throwable = null;
            Object var9_10 = null;
            try {
                T record;
                Statement statement = connection.createStatement(1004, 1008);
                try {
                    try (ResultSet rs = this.manager.executeQuery(query, statement);){
                        if (!rs.next()) throw new DataNotFoundException(tableName, key);
                        if (checkUnique && !rs.isLast()) throw new DataAccessException("record non unico: " + query);
                        record = creator.createRecord(rs);
                    }
                    if (statement == null) return record;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (statement == null) throw throwable;
                    statement.close();
                    throw throwable;
                }
                statement.close();
                return record;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (SQLException e2) {
            throw new DataAccessException(e2);
        }
    }

    public <R> RecordCreator<R> buildCreator(Class<R> recordClass) {
        GenericRecordCreator<R> creator;
        try {
            creator = new GenericRecordCreator<R>(this, recordClass);
        }
        catch (Exception e2) {
            throw new DataAccessException(e2);
        }
        return creator;
    }

    public String identity(String value) {
        return value;
    }

    @Deprecated
    public static URL toUrl(String value) {
        URL url;
        try {
            url = new URL(value);
        }
        catch (MalformedURLException e2) {
            url = null;
        }
        return url;
    }
}

