/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.csv;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.homelinux.elabor.csv.CsvLineParser;
import org.homelinux.elabor.csv.CsvReaderException;
import org.homelinux.elabor.csv.LineParser;

public class CsvReader
implements Iterator<String[]> {
    public static final String COMMA_DELIMITER = ",";
    public static final String UTF8 = "UTF-8";
    public static final String ISO_8859_1 = "iso-8859-1";
    private BufferedReader bufferedReader;
    private String delimiter;
    private int lineNumber;
    private String nextLine;
    private LineParser parser;

    public CsvReader() {
        this(COMMA_DELIMITER);
    }

    public CsvReader(String delimiter) {
        this(delimiter, new CsvLineParser());
    }

    public CsvReader(String delimiter, LineParser lineParser) {
        this.setDelimiter(delimiter);
        this.lineNumber = 0;
        this.parser = lineParser;
    }

    public void setLineParser(LineParser parser) {
        this.parser = parser;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public void setFile(String fileName) throws IOException {
        File file = new File(fileName);
        this.setFile(file);
    }

    public void setFile(File file) throws IOException {
        this.setFile(file, UTF8);
    }

    public void setFile(File file, String charset) throws IOException {
        FileInputStream inputStream = new FileInputStream(file);
        this.setInputStream(charset, inputStream);
    }

    public void setInputStream(InputStream inputStream) throws UnsupportedEncodingException, IOException {
        this.setInputStream(UTF8, inputStream);
    }

    public void setInputStream(String charset, InputStream inputStream) throws UnsupportedEncodingException, IOException {
        InputStreamReader reader = new InputStreamReader(inputStream, charset);
        this.setReader(reader);
    }

    public void close() throws IOException {
        if (this.bufferedReader != null) {
            this.bufferedReader.close();
        }
    }

    public void setReader(Reader reader) throws IOException {
        this.close();
        this.bufferedReader = new BufferedReader(reader);
        this.lineNumber = 0;
        this.nextLine = this.readLine();
    }

    public String[] getNextRow() throws IOException {
        return this.getNextRow(false);
    }

    public String[] getNextRow(boolean autoDelimiter) throws IOException {
        String[] array = null;
        ++this.lineNumber;
        if (this.nextLine == null) {
            this.bufferedReader.close();
        } else {
            if (autoDelimiter) {
                this.delimiter = this.checkSeparator();
            }
            array = this.parser.parse(this.nextLine, this.delimiter.charAt(0));
            this.nextLine = this.readLine();
        }
        return array;
    }

    private String checkSeparator() {
        String[] virgola;
        String[] puntoEVirgola = this.nextLine.split(";");
        return puntoEVirgola.length > (virgola = this.nextLine.split(COMMA_DELIMITER)).length ? ";" : COMMA_DELIMITER;
    }

    public void skipRow() throws IOException {
        this.getNextRow();
    }

    protected String readLine() throws IOException {
        return this.bufferedReader.readLine();
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public boolean hasNext() {
        return this.nextLine != null;
    }

    @Override
    public String[] next() {
        String[] next;
        try {
            next = this.getNextRow();
            if (next == null) {
                throw new NoSuchElementException();
            }
        }
        catch (IOException e2) {
            throw new CsvReaderException(e2);
        }
        return next;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

