/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.calendar;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;

public class DateRange {
    private Date start;
    private Date end;
    public static final DateRange EMPTY = DateRange.getEmptyDateRange();

    private static DateRange getEmptyDateRange() {
        Date start = new Date();
        Date end = new Date(start.getTime() + 1000L);
        return new DateRange(end, start);
    }

    public DateRange(Date start, Date end) {
        this.start = start;
        this.end = end;
    }

    public DateRange() {
        this.end = this.start = new Date();
    }

    public Date getStart() {
        return this.start;
    }

    public void setStart(Date start) {
        this.start = start;
    }

    public Date getEnd() {
        return this.end;
    }

    public void setEnd(Date end) {
        this.end = end;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "Empty Date Range";
        }
        return String.valueOf(this.start.toString()) + " - " + this.end.toString();
    }

    public boolean isEmpty() {
        return this.start.after(this.end);
    }

    public boolean includes(Date date) {
        return !date.before(this.start) && date.before(this.end);
    }

    public boolean equals(Object object) {
        if (!(object instanceof DateRange)) {
            return false;
        }
        DateRange other = (DateRange)object;
        return this.start.equals(other.start) && this.end.equals(other.end);
    }

    public int hashCode() {
        return this.start.hashCode();
    }

    public boolean overlaps(DateRange range) {
        return range.includes(this.start) || range.includes(this.end) || this.includes(range);
    }

    public boolean includes(DateRange range) {
        return this.includes(range.start) && this.includes(range.end);
    }

    public DateRange gap(DateRange range) {
        DateRange higher;
        DateRange lower;
        if (this.overlaps(range)) {
            return EMPTY;
        }
        if (this.compareTo(range) < 0) {
            lower = this;
            higher = range;
        } else {
            lower = range;
            higher = this;
        }
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTime(lower.end);
        endCalendar.add(5, 1);
        Calendar startCalendar = Calendar.getInstance();
        startCalendar.setTime(higher.start);
        startCalendar.add(5, -1);
        return new DateRange(endCalendar.getTime(), startCalendar.getTime());
    }

    public int compareTo(Object arg) {
        DateRange other = (DateRange)arg;
        if (!this.start.equals(other.start)) {
            return this.start.compareTo(other.start);
        }
        return this.end.compareTo(other.end);
    }

    public boolean abuts(DateRange arg) {
        return !this.overlaps(arg) && this.gap(arg).isEmpty();
    }

    public boolean partitionedBy(DateRange[] args) {
        if (!DateRange.isContiguous(args)) {
            return false;
        }
        return this.equals(DateRange.combination(args));
    }

    public static DateRange combination(DateRange[] args) {
        Arrays.sort(args);
        if (!DateRange.isContiguous(args)) {
            throw new IllegalArgumentException("Unable to combine date ranges");
        }
        return new DateRange(args[0].start, args[args.length - 1].end);
    }

    public static boolean isContiguous(DateRange[] args) {
        Arrays.sort(args);
        int i2 = 0;
        while (i2 < args.length - 1) {
            if (!args[i2].abuts(args[i2 + 1])) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public void intersect(DateRange range) {
        if (range.start.after(this.start)) {
            this.start = range.start;
        }
        if (range.end.before(this.end)) {
            this.end = range.end;
        }
    }

    public void restrict(DateRange range, Date date) {
        if (range.end.before(date) && range.end.after(this.start)) {
            this.start = range.end;
        }
        if (range.start.after(date) && range.start.before(this.end)) {
            this.end = range.start;
        }
    }
}

