/*
 * Decompiled with CFR 0.152.
 */
package org.homelinux.elabor.calendar;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.homelinux.elabor.calendar.ElaborCalendar;
import org.homelinux.elabor.calendar.Month;
import org.homelinux.elabor.calendar.MonthInfo;
import org.homelinux.elabor.calendar.MonthIterator;
import org.homelinux.elabor.exceptions.IllegalValueException;

public class CalendarTools {
    private static final TimeZone TIME_ZONE = TimeZone.getTimeZone("Europe/Rome");

    private CalendarTools() {
    }

    public static Date getEpoch() {
        return new Date(0L);
    }

    public static Date getEndOfTime() {
        Calendar endOfTime = Calendar.getInstance();
        endOfTime.clear();
        endOfTime.set(1, 9999);
        endOfTime.set(2, 11);
        int maxDay = endOfTime.getActualMaximum(5);
        endOfTime.set(5, maxDay);
        return endOfTime.getTime();
    }

    public static int getHoursOfMonth(int anno, Month mese) {
        int hours = 0;
        int max = CalendarTools.getDaysOfMonth(anno, mese);
        int day = 1;
        while (day <= max) {
            hours += CalendarTools.getHoursOfDay(anno, mese, day);
            ++day;
        }
        return hours;
    }

    public static String getNomeMese(Month mese) {
        int numMese = mese.getIndex();
        return CalendarTools.getNomeMese(numMese);
    }

    public static String getNomeMese(Month mese, Locale locale) {
        int numMese = mese.getIndex();
        return CalendarTools.getNomeMese(numMese, locale);
    }

    public static String getNomeMese(int numMese) {
        return CalendarTools.getNomeMese(numMese, Locale.getDefault());
    }

    public static String getNomeMese(int numMese, Locale locale) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(2, numMese - 1);
        calendar.set(5, 1);
        SimpleDateFormat format = new SimpleDateFormat("MMMM", locale);
        return format.format(calendar.getTime());
    }

    public static int getDaysOfMonth(int anno, Month mese) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(anno, mese.ordinal(), 1);
        return calendar.getActualMaximum(5);
    }

    public static boolean isLegalToSolarSwitchingMonth(Month month) {
        return Month.OCTOBER == month;
    }

    public static int getHoursOfDay(int anno, Month mese, int giorno) {
        ElaborCalendar calendar = new ElaborCalendar(anno, mese, giorno);
        Date today = calendar.getDate();
        calendar.addGiorni(1);
        Date tomorrow = calendar.getDate();
        return (int)((tomorrow.getTime() - today.getTime()) / 3600000L);
    }

    public static long getDays(Date startDate, Date endDate) {
        double days = (double)(endDate.getTime() - startDate.getTime()) / 8.64E7;
        return Math.round(days);
    }

    public static int getHours(Date startDate, Date endDate) {
        return (int)((endDate.getTime() - startDate.getTime()) / 3600000L);
    }

    public static int getHoursOfDay(Date date) {
        ElaborCalendar calendar = new ElaborCalendar(date);
        calendar.setOra(1);
        calendar.setMinuti(0);
        calendar.setSecondi(0);
        Date today = calendar.getDate();
        calendar.addGiorni(1);
        Date tomorrow = calendar.getDate();
        return (int)((tomorrow.getTime() - today.getTime()) / 3600000L);
    }

    public static ElaborCalendar getFirstHourOfMonth(int anno, Month mese) {
        return new ElaborCalendar(anno, mese, 1);
    }

    public static ElaborCalendar getLastHourOfMonth(int anno, Month mese) {
        int lastDay = CalendarTools.getDaysOfMonth(anno, mese);
        return new ElaborCalendar(anno, mese, lastDay, 24);
    }

    public static int getCurrentYear() {
        GregorianCalendar calendar = new GregorianCalendar();
        return calendar.get(1);
    }

    public static int getCurrentMonth() {
        GregorianCalendar calendar = new GregorianCalendar();
        return calendar.get(2) + 1;
    }

    public static int getFirstDecadeDay(int decade) {
        return (decade - 1) * 10 + 1;
    }

    public static int getLastDecadeDay(int anno, Month mese, int decade) {
        int result = decade < 3 ? CalendarTools.getFirstDecadeDay(decade) + 9 : CalendarTools.getDaysOfMonth(anno, mese);
        return result;
    }

    public static Calendar getCalendar(int year, Month mese, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TIME_ZONE);
        calendar.set(1, year);
        calendar.set(2, mese.ordinal());
        calendar.set(5, day);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    public static Calendar getCalendar(int year, Month month, int day, int hour, int minute) {
        Calendar calendar = CalendarTools.getCalendar(year, month, day, hour);
        calendar.set(12, minute);
        return calendar;
    }

    public static Calendar getCalendar(int year, Month mese, int day, int hour) {
        Calendar calendar = CalendarTools.getCalendar(year, mese, day);
        calendar.set(11, hour - 1);
        return calendar;
    }

    public static Date getDate(int year, Month month, int day) {
        Calendar calendar = CalendarTools.getCalendar(year, month, day, 1);
        return calendar.getTime();
    }

    public static Date getLegalDate(int year, Month month, int day, int hour) {
        Calendar calendar = CalendarTools.getCalendar(year, month, day, hour);
        return calendar.getTime();
    }

    public static boolean isSameDay(Date first, Date second) {
        SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy");
        String firstString = format.format(first);
        String secondString = format.format(second);
        return firstString.equals(secondString);
    }

    @Deprecated
    public static boolean isLegale(Calendar calendar) {
        return CalendarTools.isLegale(calendar.getTime());
    }

    @Deprecated
    public static boolean isLegale(Date date) {
        TimeZone zone = TIME_ZONE;
        return zone.inDaylightTime(date);
    }

    public static Date getNextMese(int anno, Month mese) {
        ElaborCalendar calendar = new ElaborCalendar(anno, mese);
        return CalendarTools.getNextMese(calendar);
    }

    public static Month getMese(Date data) {
        ElaborCalendar calendar = new ElaborCalendar(data);
        return calendar.getMese();
    }

    public static int getAnno(Date data) {
        ElaborCalendar calendar = new ElaborCalendar(data);
        return calendar.getAnno();
    }

    public static Date getNextMese(Date fine) {
        ElaborCalendar calendar = new ElaborCalendar(fine);
        return CalendarTools.getNextMese(calendar);
    }

    private static Date getNextMese(ElaborCalendar calendar) {
        return CalendarTools.shiftMese(calendar, 1);
    }

    public static Date getPrevMese(int anno, Month mese) {
        ElaborCalendar calendar = new ElaborCalendar(anno, mese);
        return CalendarTools.getPrevMese(calendar);
    }

    private static Date getPrevMese(ElaborCalendar calendar) {
        return CalendarTools.shiftMese(calendar, -1);
    }

    private static Date shiftMese(ElaborCalendar calendar, int nMesi) {
        calendar.setGiorno(1);
        calendar.resetTime();
        calendar.addMesi(nMesi);
        return calendar.getDate();
    }

    public static Date max(Date a2, Date b2) {
        return a2.before(b2) ? b2 : a2;
    }

    public static Date min(Date a2, Date b2) {
        return a2.after(b2) ? b2 : a2;
    }

    public static Month getStartingMonth(Date date, int anno) {
        ElaborCalendar calendar = new ElaborCalendar(date);
        return calendar.getAnno() < anno ? Month.JANUARY : calendar.getMese();
    }

    public static Month getEndingMonth(Date date, int anno) {
        ElaborCalendar calendar = new ElaborCalendar(date);
        return calendar.getAnno() > anno ? Month.DECEMBER : calendar.getMese();
    }

    public static int getMinute(Calendar date) {
        return date.get(12);
    }

    public static int getHour(Calendar date) {
        return date.get(10);
    }

    public static int getSolarHourIndex(ElaborCalendar calendar) {
        int anno = calendar.getAnnoSolare();
        Month mese = calendar.getMeseSolare();
        int giorno = calendar.getGiornoSolare();
        int ora = calendar.getOraSolare();
        return CalendarTools.getSolarHourIndex(anno, mese, giorno, ora);
    }

    public static int getSolarHourIndex(int anno, Month mese, int giorno, int ora) {
        if (giorno < 1 || giorno > CalendarTools.getDaysOfMonth(anno, mese)) {
            throw new IllegalValueException("giorno " + giorno + " non valido per il mese " + (Object)((Object)mese) + " dell'anno " + anno);
        }
        if (ora < 1 || ora > 24) {
            throw new IllegalValueException("ora " + ora + " non valida");
        }
        Date current = CalendarTools.getSolarDate(anno, mese, giorno, ora);
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TIME_ZONE);
        calendar.setTime(current);
        int startAnno = calendar.get(1);
        Month startMese = Month.values()[calendar.get(2)];
        int startGiorno = calendar.get(5);
        Date start = CalendarTools.getLegalDate(startAnno, startMese, startGiorno, 1);
        long diff = current.getTime() - start.getTime();
        return (int)Math.round((double)diff / 3600000.0);
    }

    public static Date getSolarDate(int anno, Month mese, int giorno, int ora) {
        Calendar calendar = CalendarTools.getCalendar(anno, mese, giorno, ora);
        calendar.set(16, 0);
        return calendar.getTime();
    }

    public static ElaborCalendar getCalendarFromIndex(int anno, Month mese, int giorno, int oraIndex) {
        if (oraIndex < 0 || oraIndex >= CalendarTools.getHoursOfDay(anno, mese, giorno)) {
            throw new IllegalValueException("indice " + oraIndex + " non valido");
        }
        ElaborCalendar calendar = new ElaborCalendar(TIME_ZONE, anno, mese, giorno);
        calendar.addOre(oraIndex);
        return calendar;
    }

    public static ElaborCalendar getCalendarFromQuartoIndex(int anno, Month mese, int giorno, int quartoIndex) {
        ElaborCalendar calendar = new ElaborCalendar(TIME_ZONE, anno, mese, giorno);
        calendar.setIndex(quartoIndex);
        return calendar;
    }

    public static Date getEndDate(int anno, Month mese) {
        int giorno = CalendarTools.getDaysOfMonth(anno, mese);
        return CalendarTools.getDate(anno, mese, giorno);
    }

    public static boolean isLegalToSolarHour(int anno, Month mese, int giorno, int hourIndex) {
        return hourIndex == 3 && CalendarTools.getHoursOfDay(anno, mese, giorno) == 25;
    }

    public static boolean isLegalToSolarHour(ElaborCalendar calendar) {
        int anno = calendar.getAnno();
        Month mese = calendar.getMese();
        int giorno = calendar.getGiorno();
        int hourIndex = CalendarTools.getSolarHourIndex(calendar);
        return CalendarTools.isLegalToSolarHour(anno, mese, giorno, hourIndex);
    }

    public static int getGiorno(Date date) {
        return CalendarTools.getGiorno(date, false);
    }

    public static int getGiorno(Date date, boolean midnight) {
        ElaborCalendar calendar = new ElaborCalendar(date);
        if (midnight) {
            ElaborCalendar begin = new ElaborCalendar(date);
            begin.setOra(1);
            begin.setMinuti(0);
            Date startDate = begin.getDate();
            if (date.getTime() == startDate.getTime()) {
                calendar.addMinuti(-1);
            }
        }
        return calendar.getGiorno();
    }

    public static int countDays(Date startDate, Date endDate) {
        long start = startDate.getTime();
        long end = endDate.getTime();
        return (int)Math.round((double)(end - start) / 8.64E7);
    }

    public static Date getToday() {
        ElaborCalendar calendar = new ElaborCalendar();
        calendar.resetTime();
        return calendar.getDate();
    }

    public static List<MonthInfo> getMonthInfos(Locale locale) {
        ArrayList<MonthInfo> infos = new ArrayList<MonthInfo>();
        MonthIterator iterator = new MonthIterator();
        while (iterator.hasNext()) {
            Month month = iterator.next();
            String name = CalendarTools.getNomeMese(month, locale);
            infos.add(new MonthInfo(month, name));
        }
        return infos;
    }

    public static Date nextDay(Date date) {
        ElaborCalendar calendar = new ElaborCalendar(date);
        calendar.addGiorni(1);
        return calendar.getDate();
    }

    public static Date previousDay(Date date) {
        ElaborCalendar calendar = new ElaborCalendar(date);
        calendar.addGiorni(-1);
        return calendar.getDate();
    }

    public static Date getTomorrow() {
        Date date = CalendarTools.getToday();
        ElaborCalendar calendar = new ElaborCalendar(date);
        calendar.addGiorni(1);
        return calendar.getDate();
    }

    public static boolean isAfternoon() {
        Calendar rightNow = Calendar.getInstance();
        int hour = rightNow.get(11);
        return hour > 13;
    }

    public static Date minNullable(Date a2, Date b2) {
        return a2 == null || b2 != null && a2.after(b2) ? b2 : a2;
    }

    public static Date maxNullable(Date a2, Date b2) {
        return a2 == null || b2 != null && a2.before(b2) ? b2 : a2;
    }

    public static Date getStartOfMonth(Date date) {
        ElaborCalendar calendar = new ElaborCalendar(date);
        calendar.setGiorno(1);
        calendar.resetTime();
        return calendar.getDate();
    }

    public static Date getEndOfMonth(Date data) {
        return CalendarTools.previousDay(CalendarTools.getNextMese(data));
    }

    public static boolean isFineMese(Date data) {
        return data.equals(CalendarTools.getEndOfMonth(data));
    }

    public static boolean overlaps(Date startA, Date endA, Date startB, Date endB) {
        return !startA.after(endB) && !startB.after(endA);
    }

    public static boolean isLegalToSolarDay(Date dataMisura) {
        return CalendarTools.getHoursOfDay(dataMisura) == 25;
    }

    public static boolean isSolarToLegalDay(Date dataMisura) {
        return CalendarTools.getHoursOfDay(dataMisura) == 23;
    }
}

