/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class ArrayTypeReference
extends SingleTypeReference {
    public int dimensions;
    private Annotation[][] annotationsOnDimensions;
    public int originalSourceEnd;
    public int extendedDimensions;

    public ArrayTypeReference(char[] source, int dimensions, long pos) {
        super(source, pos);
        this.originalSourceEnd = this.sourceEnd;
        this.dimensions = dimensions;
        this.annotationsOnDimensions = null;
    }

    public ArrayTypeReference(char[] source, int dimensions, Annotation[][] annotationsOnDimensions, long pos) {
        this(source, dimensions, pos);
        if (annotationsOnDimensions != null) {
            this.bits |= 0x100000;
        }
        this.annotationsOnDimensions = annotationsOnDimensions;
    }

    @Override
    public int dimensions() {
        return this.dimensions;
    }

    @Override
    public int extraDimensions() {
        return this.extendedDimensions;
    }

    @Override
    public Annotation[][] getAnnotationsOnDimensions(boolean useSourceOrder) {
        if (useSourceOrder || this.annotationsOnDimensions == null || this.annotationsOnDimensions.length == 0 || this.extendedDimensions == 0 || this.extendedDimensions == this.dimensions) {
            return this.annotationsOnDimensions;
        }
        Annotation[][] externalAnnotations = new Annotation[this.dimensions][];
        int baseDimensions = this.dimensions - this.extendedDimensions;
        System.arraycopy(this.annotationsOnDimensions, baseDimensions, externalAnnotations, 0, this.extendedDimensions);
        System.arraycopy(this.annotationsOnDimensions, 0, externalAnnotations, this.extendedDimensions, baseDimensions);
        return externalAnnotations;
    }

    @Override
    public void setAnnotationsOnDimensions(Annotation[][] annotationsOnDimensions) {
        this.annotationsOnDimensions = annotationsOnDimensions;
    }

    @Override
    public char[][] getParameterizedTypeName() {
        int dim = this.dimensions;
        char[] dimChars = new char[dim * 2];
        int i2 = 0;
        while (i2 < dim) {
            int index = i2 * 2;
            dimChars[index] = 91;
            dimChars[index + 1] = 93;
            ++i2;
        }
        return new char[][]{CharOperation.concat(this.token, dimChars)};
    }

    @Override
    protected TypeBinding getTypeBinding(Scope scope) {
        if (this.resolvedType != null) {
            return this.resolvedType;
        }
        if (this.dimensions > 255) {
            scope.problemReporter().tooManyDimensions(this);
        }
        TypeBinding leafComponentType = scope.getType(this.token);
        return scope.createArrayType(leafComponentType, this.dimensions);
    }

    @Override
    public StringBuffer printExpression(int indent, StringBuffer output) {
        super.printExpression(indent, output);
        if ((this.bits & 0x4000) != 0) {
            int i2 = 0;
            while (i2 < this.dimensions - 1) {
                if (this.annotationsOnDimensions != null && this.annotationsOnDimensions[i2] != null) {
                    output.append(' ');
                    ArrayTypeReference.printAnnotations(this.annotationsOnDimensions[i2], output);
                    output.append(' ');
                }
                output.append("[]");
                ++i2;
            }
            if (this.annotationsOnDimensions != null && this.annotationsOnDimensions[this.dimensions - 1] != null) {
                output.append(' ');
                ArrayTypeReference.printAnnotations(this.annotationsOnDimensions[this.dimensions - 1], output);
                output.append(' ');
            }
            output.append("...");
        } else {
            int i3 = 0;
            while (i3 < this.dimensions) {
                if (this.annotationsOnDimensions != null && this.annotationsOnDimensions[i3] != null) {
                    output.append(" ");
                    ArrayTypeReference.printAnnotations(this.annotationsOnDimensions[i3], output);
                    output.append(" ");
                }
                output.append("[]");
                ++i3;
            }
        }
        return output;
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            if (this.annotations != null) {
                Annotation[] typeAnnotations = this.annotations[0];
                int i2 = 0;
                int length = typeAnnotations == null ? 0 : typeAnnotations.length;
                while (i2 < length) {
                    typeAnnotations[i2].traverse(visitor, scope);
                    ++i2;
                }
            }
            if (this.annotationsOnDimensions != null) {
                int i3 = 0;
                int max = this.annotationsOnDimensions.length;
                while (i3 < max) {
                    Annotation[] annotations2 = this.annotationsOnDimensions[i3];
                    if (annotations2 != null) {
                        int j2 = 0;
                        int max2 = annotations2.length;
                        while (j2 < max2) {
                            Annotation annotation = annotations2[j2];
                            annotation.traverse(visitor, scope);
                            ++j2;
                        }
                    }
                    ++i3;
                }
            }
        }
        visitor.endVisit(this, scope);
    }

    @Override
    public void traverse(ASTVisitor visitor, ClassScope scope) {
        if (visitor.visit(this, scope)) {
            if (this.annotations != null) {
                Annotation[] typeAnnotations = this.annotations[0];
                int i2 = 0;
                int length = typeAnnotations == null ? 0 : typeAnnotations.length;
                while (i2 < length) {
                    typeAnnotations[i2].traverse(visitor, scope);
                    ++i2;
                }
            }
            if (this.annotationsOnDimensions != null) {
                int i3 = 0;
                int max = this.annotationsOnDimensions.length;
                while (i3 < max) {
                    Annotation[] annotations2 = this.annotationsOnDimensions[i3];
                    if (annotations2 != null) {
                        int j2 = 0;
                        int max2 = annotations2.length;
                        while (j2 < max2) {
                            Annotation annotation = annotations2[j2];
                            annotation.traverse(visitor, scope);
                            ++j2;
                        }
                    }
                    ++i3;
                }
            }
        }
        visitor.endVisit(this, scope);
    }

    @Override
    protected TypeBinding internalResolveType(Scope scope, int location) {
        TypeBinding internalResolveType = super.internalResolveType(scope, location);
        return internalResolveType;
    }

    @Override
    public boolean hasNullTypeAnnotation(TypeReference.AnnotationPosition position) {
        switch (position) {
            case LEAF_TYPE: {
                return super.hasNullTypeAnnotation(position);
            }
            case MAIN_TYPE: {
                if (this.annotationsOnDimensions == null || this.annotationsOnDimensions.length <= 0) break;
                Annotation[] innerAnnotations = this.annotationsOnDimensions[0];
                return ArrayTypeReference.containsNullAnnotation(innerAnnotations);
            }
            case ANY: {
                if (super.hasNullTypeAnnotation(position)) {
                    return true;
                }
                if (this.resolvedType != null && !this.resolvedType.hasNullTypeAnnotations()) {
                    return false;
                }
                if (this.annotationsOnDimensions == null) break;
                int i2 = 0;
                while (i2 < this.annotationsOnDimensions.length) {
                    Annotation[] innerAnnotations = this.annotationsOnDimensions[i2];
                    if (ArrayTypeReference.containsNullAnnotation(innerAnnotations)) {
                        return true;
                    }
                    ++i2;
                }
                break;
            }
        }
        return false;
    }
}

