/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.displaytag.properties.MediaTypeEnum;

public final class MediaUtil {
    private static Log log = LogFactory.getLog(MediaUtil.class);

    private MediaUtil() {
    }

    public static void setMedia(SupportsMedia mediaSupporter, String media) {
        if (mediaSupporter == null) {
            return;
        }
        if (StringUtils.isBlank(media) || media.toLowerCase().indexOf("all") > -1) {
            mediaSupporter.setSupportedMedia(null);
            return;
        }
        ArrayList<MediaTypeEnum> supportedMedia = new ArrayList<MediaTypeEnum>();
        String[] values = StringUtils.split(media);
        for (int i2 = 0; i2 < values.length; ++i2) {
            String value = values[i2];
            if (StringUtils.isBlank(value)) continue;
            MediaTypeEnum type = MediaTypeEnum.fromName(value.toLowerCase());
            if (type == null) {
                log.warn("Unrecognized value for attribute \"media\" value=\"" + value + "\"");
                continue;
            }
            supportedMedia.add(type);
        }
        mediaSupporter.setSupportedMedia(supportedMedia);
    }

    public static boolean availableForMedia(SupportsMedia mediaSupporter, MediaTypeEnum mediaType) {
        if (mediaSupporter == null) {
            return false;
        }
        List supportedMedia = mediaSupporter.getSupportedMedia();
        if (supportedMedia == null) {
            return true;
        }
        return supportedMedia.contains(mediaType);
    }

    public static interface SupportsMedia {
        public void setSupportedMedia(List var1);

        public List getSupportedMedia();
    }
}

