/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.pagination;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.IteratorUtils;

public class PaginationHelper {
    private final int pageNumber;
    private final int pageSize;

    public PaginationHelper(int pageNumber, int pageSize) {
        this.pageNumber = pageNumber;
        this.pageSize = pageSize;
    }

    public Iterator getIterator(Object data) {
        if (data instanceof List) {
            return this.getIterator((List)data);
        }
        return IteratorUtils.getIterator(data);
    }

    public Iterator getIterator(List data) {
        int start = this.getStart(data.size());
        int end = this.getEnd(data.size(), start);
        return data.subList(start, end).iterator();
    }

    protected int getStart(int listSize) {
        int start = (this.pageNumber - 1) * this.pageSize;
        if (start >= listSize) {
            start = 0;
        }
        return start;
    }

    protected int getEnd(int listSize, int start) {
        int end = this.pageNumber * this.pageSize;
        if (end > listSize && (end = listSize) - start > this.pageSize) {
            end = this.pageSize;
        }
        return end;
    }
}

