/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.export;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.displaytag.Messages;
import org.displaytag.exception.WrappedRuntimeException;
import org.displaytag.export.ExportView;
import org.displaytag.model.TableModel;
import org.displaytag.properties.MediaTypeEnum;
import org.displaytag.properties.TableProperties;
import org.displaytag.util.ReflectHelper;

public final class ExportViewFactory {
    private static ExportViewFactory instance;
    private static Log log;
    private final Map viewClasses = new HashMap();

    private ExportViewFactory() {
        TableProperties properties = TableProperties.getInstance(null);
        String[] exportTypes = properties.getExportTypes();
        if (log.isInfoEnabled()) {
            log.info(Messages.getString("ExportViewFactory.initializing", new Object[]{ArrayUtils.toString(exportTypes)}));
        }
        for (int j2 = 0; j2 < exportTypes.length; ++j2) {
            String className = properties.getExportClass(exportTypes[j2]);
            this.registerExportView(exportTypes[j2], className);
        }
    }

    public static synchronized ExportViewFactory getInstance() {
        if (instance == null) {
            instance = new ExportViewFactory();
        }
        return instance;
    }

    public void registerExportView(String name, String viewClassName) {
        Class exportClass;
        try {
            exportClass = ReflectHelper.classForName(viewClassName);
        }
        catch (ClassNotFoundException e2) {
            log.error(Messages.getString("ExportViewFactory.classnotfound", new Object[]{name, viewClassName}));
            return;
        }
        catch (NoClassDefFoundError e3) {
            log.warn(Messages.getString("ExportViewFactory.noclassdef", new Object[]{name, viewClassName, e3.getMessage()}));
            return;
        }
        try {
            exportClass.newInstance();
        }
        catch (InstantiationException e4) {
            log.error(Messages.getString("ExportViewFactory.instantiationexception", new Object[]{name, viewClassName, e4.getMessage()}));
            return;
        }
        catch (IllegalAccessException e5) {
            log.error(Messages.getString("ExportViewFactory.illegalaccess", new Object[]{name, viewClassName, e5.getMessage()}));
            return;
        }
        catch (NoClassDefFoundError e6) {
            log.warn(Messages.getString("ExportViewFactory.noclassdef", new Object[]{name, viewClassName, e6.getMessage()}));
            return;
        }
        MediaTypeEnum media = MediaTypeEnum.registerMediaType(name);
        this.viewClasses.put(media, exportClass);
        if (log.isDebugEnabled()) {
            log.debug(Messages.getString("ExportViewFactory.added", new Object[]{media, viewClassName}));
        }
    }

    public ExportView getView(MediaTypeEnum exportType, TableModel tableModel, boolean exportFullList, boolean includeHeader, boolean decorateValues) {
        ExportView view;
        Class viewClass = (Class)this.viewClasses.get(exportType);
        try {
            view = (ExportView)viewClass.newInstance();
        }
        catch (InstantiationException e2) {
            throw new WrappedRuntimeException(this.getClass(), (Throwable)e2);
        }
        catch (IllegalAccessException e3) {
            throw new WrappedRuntimeException(this.getClass(), (Throwable)e3);
        }
        view.setParameters(tableModel, exportFullList, includeHeader, decorateValues);
        return view;
    }

    static {
        log = LogFactory.getLog(ExportViewFactory.class);
    }
}

