/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.export;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.PageSize;
import com.lowagie.text.Table;
import java.io.OutputStream;
import javax.servlet.jsp.JspException;
import org.displaytag.Messages;
import org.displaytag.exception.BaseNestableJspTagException;
import org.displaytag.exception.SeverityEnum;
import org.displaytag.export.BinaryExportView;
import org.displaytag.model.TableModel;
import org.displaytag.render.ItextTableWriter;

public abstract class DefaultItextExportView
implements BinaryExportView {
    private TableModel model;
    static /* synthetic */ Class class$org$displaytag$export$DefaultItextExportView;

    public void setParameters(TableModel tableModel, boolean exportFullList, boolean includeHeader, boolean decorateValues) {
        this.model = tableModel;
    }

    public String getMimeType() {
        return null;
    }

    public void doExport(OutputStream out) throws JspException {
        try {
            Document document = new Document(PageSize.A4.rotate(), 60.0f, 60.0f, 40.0f, 40.0f);
            this.initItextWriter(document, out);
            document.open();
            Table table = new Table(this.model.getNumberOfColumns());
            ItextTableWriter writer = new ItextTableWriter(table, document);
            writer.writeTable(this.model, "-1");
            document.add(table);
            document.close();
        }
        catch (Exception e2) {
            throw new ItextGenerationException(e2);
        }
    }

    protected abstract void initItextWriter(Document var1, OutputStream var2) throws DocumentException;

    static class ItextGenerationException
    extends BaseNestableJspTagException {
        private static final long serialVersionUID = 899149338534L;

        public ItextGenerationException(Throwable cause) {
            super(class$org$displaytag$export$DefaultItextExportView == null ? (class$org$displaytag$export$DefaultItextExportView = DefaultItextExportView.class$("org.displaytag.export.DefaultItextExportView")) : class$org$displaytag$export$DefaultItextExportView, Messages.getString("DefaultItextExportView.errorexporting"), cause);
            this.initCause(cause);
        }

        public SeverityEnum getSeverity() {
            return SeverityEnum.ERROR;
        }
    }
}

