/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.decorator;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.jsp.PageContext;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.displaytag.decorator.DisplaytagColumnDecorator;
import org.displaytag.decorator.TableDecorator;
import org.displaytag.exception.DecoratorException;
import org.displaytag.model.HeaderCell;
import org.displaytag.model.TableModel;

public class TotalTableDecorator
extends TableDecorator {
    private static Log log = LogFactory.getLog(TotalTableDecorator.class);
    private Map grandTotals = new HashMap();
    private Map subTotals = new HashMap();
    private Map previousValues = new HashMap();
    private String groupPropertyName;
    private String subtotalLabel = "{0} subtotal";
    private String totalLabel = "Total";

    public void setSubtotalLabel(String subtotalLabel) {
        this.subtotalLabel = subtotalLabel;
    }

    public void setTotalLabel(String totalLabel) {
        this.totalLabel = totalLabel;
    }

    public void init(PageContext context, Object decorated, TableModel tableModel) {
        super.init(context, decorated, tableModel);
        this.groupPropertyName = null;
        this.grandTotals.clear();
        this.subTotals.clear();
        this.previousValues.clear();
        Iterator it = tableModel.getHeaderCellList().iterator();
        while (it.hasNext()) {
            HeaderCell cell = (HeaderCell)it.next();
            if (cell.getGroup() != 1) continue;
            this.groupPropertyName = cell.getBeanPropertyName();
        }
    }

    public String startRow() {
        String subtotalRow = null;
        if (this.groupPropertyName != null) {
            Object groupedPropertyValue = this.evaluate(this.groupPropertyName);
            Object previousGroupedPropertyValue = this.previousValues.get(this.groupPropertyName);
            if (previousGroupedPropertyValue != null && !ObjectUtils.equals(previousGroupedPropertyValue, groupedPropertyValue)) {
                subtotalRow = this.createTotalRow(false);
            }
            this.previousValues.put(this.groupPropertyName, groupedPropertyValue);
        }
        Iterator it = this.tableModel.getHeaderCellList().iterator();
        while (it.hasNext()) {
            HeaderCell cell = (HeaderCell)it.next();
            if (!cell.isTotaled()) continue;
            String totalPropertyName = cell.getBeanPropertyName();
            Number amount = (Number)this.evaluate(totalPropertyName);
            Number previousSubTotal = (Number)this.subTotals.get(totalPropertyName);
            Number previousGrandTotals = (Number)this.grandTotals.get(totalPropertyName);
            this.subTotals.put(totalPropertyName, new Double((previousSubTotal != null ? previousSubTotal.doubleValue() : 0.0) + (amount != null ? amount.doubleValue() : 0.0)));
            this.grandTotals.put(totalPropertyName, new Double((previousGrandTotals != null ? previousGrandTotals.doubleValue() : 0.0) + (amount != null ? amount.doubleValue() : 0.0)));
        }
        return subtotalRow;
    }

    public final String finishRow() {
        StringBuffer buffer = new StringBuffer(1000);
        if (this.getViewIndex() == ((List)this.getDecoratedObject()).size() - 1) {
            if (this.groupPropertyName != null) {
                buffer.append(this.createTotalRow(false));
            }
            buffer.append(this.createTotalRow(true));
        }
        return buffer.toString();
    }

    protected String createTotalRow(boolean grandTotal) {
        StringBuffer buffer = new StringBuffer(1000);
        buffer.append("\n<tr class=\"total\">");
        List headerCells = this.tableModel.getHeaderCellList();
        Iterator it = headerCells.iterator();
        while (it.hasNext()) {
            HeaderCell cell = (HeaderCell)it.next();
            String cssClass = ObjectUtils.toString(cell.getHtmlAttributes().get("class"));
            buffer.append("<td");
            if (StringUtils.isNotEmpty(cssClass)) {
                buffer.append(" class=\"");
                buffer.append(cssClass);
                buffer.append("\"");
            }
            buffer.append(">");
            if (cell.isTotaled()) {
                String totalPropertyName = cell.getBeanPropertyName();
                Object total = grandTotal ? this.grandTotals.get(totalPropertyName) : this.subTotals.get(totalPropertyName);
                DisplaytagColumnDecorator[] decorators = cell.getColumnDecorators();
                for (int j2 = 0; j2 < decorators.length; ++j2) {
                    try {
                        total = decorators[j2].decorate(total, this.getPageContext(), this.tableModel.getMedia());
                        continue;
                    }
                    catch (DecoratorException e2) {
                        log.warn(e2.getMessage(), e2);
                    }
                }
                buffer.append(total);
            } else if (this.groupPropertyName != null && this.groupPropertyName.equals(cell.getBeanPropertyName())) {
                buffer.append(grandTotal ? this.totalLabel : MessageFormat.format(this.subtotalLabel, this.previousValues.get(this.groupPropertyName)));
            }
            buffer.append("</td>");
        }
        buffer.append("</tr>");
        this.subTotals.clear();
        return buffer.toString();
    }
}

