/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.decorator;

import javax.servlet.jsp.PageContext;
import org.apache.commons.lang.StringUtils;
import org.displaytag.decorator.ColumnDecorator;
import org.displaytag.decorator.DecoratorFactory;
import org.displaytag.decorator.DisplaytagColumnDecorator;
import org.displaytag.decorator.TableDecorator;
import org.displaytag.exception.DecoratorException;
import org.displaytag.exception.DecoratorInstantiationException;
import org.displaytag.properties.MediaTypeEnum;
import org.displaytag.util.ReflectHelper;

public class DefaultDecoratorFactory
implements DecoratorFactory {
    public TableDecorator loadTableDecorator(PageContext pageContext, String decoratorName) throws DecoratorInstantiationException {
        if (StringUtils.isBlank(decoratorName)) {
            return null;
        }
        Object decorator = pageContext.findAttribute(decoratorName);
        if (decorator == null) {
            try {
                decorator = ReflectHelper.classForName(decoratorName).newInstance();
            }
            catch (ClassNotFoundException e2) {
                throw new DecoratorInstantiationException(DefaultDecoratorFactory.class, decoratorName, e2);
            }
            catch (InstantiationException e3) {
                throw new DecoratorInstantiationException(DefaultDecoratorFactory.class, decoratorName, e3);
            }
            catch (IllegalAccessException e4) {
                throw new DecoratorInstantiationException(DefaultDecoratorFactory.class, decoratorName, e4);
            }
        }
        if (decorator instanceof TableDecorator) {
            return (TableDecorator)decorator;
        }
        throw new DecoratorInstantiationException(DefaultDecoratorFactory.class, decoratorName, new ClassCastException(decorator.getClass().getName()));
    }

    public DisplaytagColumnDecorator loadColumnDecorator(PageContext pageContext, String decoratorName) throws DecoratorInstantiationException {
        if (StringUtils.isBlank(decoratorName)) {
            return null;
        }
        Object decorator = pageContext.findAttribute(decoratorName);
        if (decorator == null) {
            try {
                decorator = ReflectHelper.classForName(decoratorName).newInstance();
            }
            catch (ClassNotFoundException e2) {
                throw new DecoratorInstantiationException(DefaultDecoratorFactory.class, decoratorName, e2);
            }
            catch (InstantiationException e3) {
                throw new DecoratorInstantiationException(DefaultDecoratorFactory.class, decoratorName, e3);
            }
            catch (IllegalAccessException e4) {
                throw new DecoratorInstantiationException(DefaultDecoratorFactory.class, decoratorName, e4);
            }
        }
        if (decorator instanceof DisplaytagColumnDecorator) {
            return (DisplaytagColumnDecorator)decorator;
        }
        if (decorator instanceof ColumnDecorator) {
            return new DeprecatedDecoratorWrapper((ColumnDecorator)decorator);
        }
        throw new DecoratorInstantiationException(DefaultDecoratorFactory.class, decoratorName, new ClassCastException(decorator.getClass().getName()));
    }

    private static class DeprecatedDecoratorWrapper
    implements DisplaytagColumnDecorator {
        private ColumnDecorator decorator;

        public DeprecatedDecoratorWrapper(ColumnDecorator decorator) {
            this.decorator = decorator;
        }

        public Object decorate(Object columnValue, PageContext pageContext, MediaTypeEnum media) throws DecoratorException {
            return this.decorator.decorate(columnValue);
        }
    }
}

