/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.VersionedDataInputStream;
import org.aspectj.weaver.patterns.PatternNode;
import org.aspectj.weaver.patterns.PatternNodeVisitor;
import org.aspectj.weaver.patterns.TypeVariablePattern;

public class TypeVariablePatternList
extends PatternNode {
    public static final TypeVariablePatternList EMPTY = new TypeVariablePatternList(new TypeVariablePattern[0]);
    private TypeVariablePattern[] patterns;

    public TypeVariablePatternList(TypeVariablePattern[] typeVars) {
        this.patterns = typeVars;
    }

    public TypeVariablePattern[] getTypeVariablePatterns() {
        return this.patterns;
    }

    public TypeVariablePattern lookupTypeVariable(String name) {
        for (int i2 = 0; i2 < this.patterns.length; ++i2) {
            if (!this.patterns[i2].getName().equals(name)) continue;
            return this.patterns[i2];
        }
        return null;
    }

    public boolean isEmpty() {
        return this.patterns == null || this.patterns.length == 0;
    }

    public void write(DataOutputStream s2) throws IOException {
        s2.writeInt(this.patterns.length);
        for (int i2 = 0; i2 < this.patterns.length; ++i2) {
            this.patterns[i2].write(s2);
        }
        this.writeLocation(s2);
    }

    public static TypeVariablePatternList read(VersionedDataInputStream s2, ISourceContext context) throws IOException {
        TypeVariablePatternList ret = EMPTY;
        int length = s2.readInt();
        if (length > 0) {
            TypeVariablePattern[] patterns = new TypeVariablePattern[length];
            for (int i2 = 0; i2 < patterns.length; ++i2) {
                patterns[i2] = TypeVariablePattern.read(s2, context);
            }
            ret = new TypeVariablePatternList(patterns);
        }
        ret.readLocation(context, s2);
        return ret;
    }

    public Object accept(PatternNodeVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public Object traverse(PatternNodeVisitor visitor, Object data) {
        Object ret = this.accept(visitor, data);
        for (int i2 = 0; i2 < this.patterns.length; ++i2) {
            this.patterns[i2].traverse(visitor, ret);
        }
        return ret;
    }
}

