/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.Map;
import org.aspectj.bridge.MessageUtil;
import org.aspectj.util.FuzzyBoolean;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.VersionedDataInputStream;
import org.aspectj.weaver.WeaverMessages;
import org.aspectj.weaver.World;
import org.aspectj.weaver.patterns.AnnotationTypePattern;
import org.aspectj.weaver.patterns.Bindings;
import org.aspectj.weaver.patterns.IScope;
import org.aspectj.weaver.patterns.PatternNodeVisitor;
import org.aspectj.weaver.patterns.TypePattern;

class AnyWithAnnotationTypePattern
extends TypePattern {
    public AnyWithAnnotationTypePattern(AnnotationTypePattern atp) {
        super(false, false);
        this.annotationPattern = atp;
    }

    public Object accept(PatternNodeVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    protected boolean couldEverMatchSameTypesAs(TypePattern other) {
        return true;
    }

    protected boolean matchesExactly(ResolvedType type) {
        this.annotationPattern.resolve(type.getWorld());
        boolean b2 = false;
        b2 = type.temporaryAnnotationTypes != null ? this.annotationPattern.matches(type, type.temporaryAnnotationTypes).alwaysTrue() : this.annotationPattern.matches(type).alwaysTrue();
        return b2;
    }

    public TypePattern resolveBindings(IScope scope, Bindings bindings, boolean allowBinding, boolean requireExactType) {
        if (requireExactType) {
            scope.getWorld().getMessageHandler().handleMessage(MessageUtil.error(WeaverMessages.format("wildcardTypePatternNotAllowed"), this.getSourceLocation()));
            return NO;
        }
        return super.resolveBindings(scope, bindings, allowBinding, requireExactType);
    }

    protected boolean matchesExactly(ResolvedType type, ResolvedType annotatedType) {
        this.annotationPattern.resolve(type.getWorld());
        return this.annotationPattern.matches(annotatedType).alwaysTrue();
    }

    public FuzzyBoolean matchesInstanceof(ResolvedType type) {
        if (Modifier.isFinal(type.getModifiers())) {
            return FuzzyBoolean.fromBoolean(this.matchesExactly(type));
        }
        return FuzzyBoolean.MAYBE;
    }

    public TypePattern parameterizeWith(Map typeVariableMap, World w) {
        AnyWithAnnotationTypePattern ret = new AnyWithAnnotationTypePattern(this.annotationPattern.parameterizeWith(typeVariableMap, w));
        ret.copyLocationFrom(this);
        return ret;
    }

    public void write(DataOutputStream s2) throws IOException {
        s2.writeByte(10);
        this.annotationPattern.write(s2);
        this.writeLocation(s2);
    }

    public static TypePattern read(VersionedDataInputStream s2, ISourceContext c2) throws IOException {
        AnnotationTypePattern annPatt = AnnotationTypePattern.read(s2, c2);
        AnyWithAnnotationTypePattern ret = new AnyWithAnnotationTypePattern(annPatt);
        ret.readLocation(c2, s2);
        return ret;
    }

    protected boolean matchesSubtypes(ResolvedType type) {
        return true;
    }

    public boolean isStar() {
        return false;
    }

    public String toString() {
        return "(" + this.annotationPattern + " *)";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AnyWithAnnotationTypePattern)) {
            return false;
        }
        AnyWithAnnotationTypePattern awatp = (AnyWithAnnotationTypePattern)obj;
        return this.annotationPattern.equals(awatp.annotationPattern);
    }

    public int hashCode() {
        return this.annotationPattern.hashCode();
    }
}

