/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.bcel;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.aspectj.apache.bcel.classfile.Attribute;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.Field;
import org.aspectj.apache.bcel.classfile.Synthetic;
import org.aspectj.apache.bcel.classfile.annotation.AnnotationGen;
import org.aspectj.apache.bcel.generic.FieldGen;
import org.aspectj.util.GenericSignature;
import org.aspectj.util.GenericSignatureParser;
import org.aspectj.weaver.AjAttribute;
import org.aspectj.weaver.AnnotationAJ;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.ResolvedMemberImpl;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.World;
import org.aspectj.weaver.bcel.AtAjAttributes;
import org.aspectj.weaver.bcel.BcelAnnotation;
import org.aspectj.weaver.bcel.BcelGenericSignatureToTypeXConverter;
import org.aspectj.weaver.bcel.BcelObjectType;
import org.aspectj.weaver.bcel.Utility;

final class BcelField
extends ResolvedMemberImpl {
    public static int AccSynthetic = 4096;
    private Field field;
    private boolean isAjSynthetic;
    private boolean isSynthetic = false;
    private AnnotationAJ[] annotations;
    private final World world;
    private final BcelObjectType bcelObjectType;
    private UnresolvedType genericFieldType = null;
    private boolean unpackedGenericSignature = false;
    private boolean annotationsAdded = false;

    BcelField(BcelObjectType declaringType, Field field) {
        super(FIELD, declaringType.getResolvedTypeX(), field.getModifiers(), field.getName(), field.getSignature());
        this.field = field;
        this.world = declaringType.getResolvedTypeX().getWorld();
        this.bcelObjectType = declaringType;
        this.unpackAttributes(this.world);
        this.checkedExceptions = UnresolvedType.NONE;
    }

    BcelField(String declaringTypeName, Field field, World world) {
        super(FIELD, UnresolvedType.forName(declaringTypeName), field.getModifiers(), field.getName(), field.getSignature());
        this.field = field;
        this.world = world;
        this.bcelObjectType = null;
        this.unpackAttributes(world);
        this.checkedExceptions = UnresolvedType.NONE;
    }

    private void unpackAttributes(World world) {
        Attribute[] attrs = this.field.getAttributes();
        if (attrs != null && attrs.length > 0) {
            List<AjAttribute> as = Utility.readAjAttributes(this.getDeclaringType().getClassName(), attrs, this.getSourceContext(world), world, this.bcelObjectType != null ? this.bcelObjectType.getWeaverVersionAttribute() : AjAttribute.WeaverVersionInfo.CURRENT);
            as.addAll(AtAjAttributes.readAj5FieldAttributes(this.field, this, world.resolve(this.getDeclaringType()), this.getSourceContext(world), world.getMessageHandler()));
            for (AjAttribute a2 : as) {
                if (a2 instanceof AjAttribute.AjSynthetic) {
                    this.isAjSynthetic = true;
                    continue;
                }
                throw new BCException("weird field attribute " + a2);
            }
        }
        this.isAjSynthetic = false;
        for (int i2 = attrs.length - 1; i2 >= 0; --i2) {
            if (!(attrs[i2] instanceof Synthetic)) continue;
            this.isSynthetic = true;
        }
        if ((this.field.getModifiers() & AccSynthetic) != 0) {
            this.isSynthetic = true;
        }
    }

    public boolean isAjSynthetic() {
        return this.isAjSynthetic;
    }

    public boolean isSynthetic() {
        return this.isSynthetic;
    }

    public boolean hasAnnotation(UnresolvedType ofType) {
        this.ensureAnnotationTypesRetrieved();
        for (ResolvedType aType : this.annotationTypes) {
            if (!aType.equals(ofType)) continue;
            return true;
        }
        return false;
    }

    public ResolvedType[] getAnnotationTypes() {
        this.ensureAnnotationTypesRetrieved();
        ResolvedType[] ret = new ResolvedType[this.annotationTypes.size()];
        this.annotationTypes.toArray(ret);
        return ret;
    }

    public AnnotationAJ[] getAnnotations() {
        this.ensureAnnotationTypesRetrieved();
        return this.annotations;
    }

    public AnnotationAJ getAnnotationOfType(UnresolvedType ofType) {
        this.ensureAnnotationTypesRetrieved();
        for (int i2 = 0; i2 < this.annotations.length; ++i2) {
            if (!this.annotations[i2].getTypeName().equals(ofType.getName())) continue;
            return this.annotations[i2];
        }
        return null;
    }

    private void ensureAnnotationTypesRetrieved() {
        if (this.annotationTypes == null) {
            AnnotationGen[] annos = this.field.getAnnotations();
            if (annos == null || annos.length == 0) {
                this.annotationTypes = Collections.emptySet();
                this.annotations = AnnotationAJ.EMPTY_ARRAY;
            } else {
                this.annotationTypes = new HashSet();
                this.annotations = new AnnotationAJ[annos.length];
                for (int i2 = 0; i2 < annos.length; ++i2) {
                    AnnotationGen annotation = annos[i2];
                    this.annotationTypes.add(this.world.resolve(UnresolvedType.forSignature(annotation.getTypeSignature())));
                    this.annotations[i2] = new BcelAnnotation(annotation, this.world);
                }
            }
        }
    }

    public void addAnnotation(AnnotationAJ annotation) {
        this.ensureAnnotationTypesRetrieved();
        int len = this.annotations.length;
        AnnotationAJ[] ret = new AnnotationAJ[len + 1];
        System.arraycopy(this.annotations, 0, ret, 0, len);
        ret[len] = annotation;
        this.annotations = ret;
        if (this.annotationTypes == Collections.EMPTY_SET) {
            this.annotationTypes = new HashSet();
        }
        String typename = annotation.getTypeSignature();
        this.annotationTypes.add(UnresolvedType.forSignature(typename).resolve(this.world));
        this.annotationsAdded = true;
    }

    public UnresolvedType getGenericReturnType() {
        this.unpackGenericSignature();
        return this.genericFieldType;
    }

    public Field getFieldAsIs() {
        return this.field;
    }

    public Field getField(ConstantPool cpg) {
        if (!this.annotationsAdded) {
            return this.field;
        }
        FieldGen fg = new FieldGen(this.field, cpg);
        List<AnnotationGen> alreadyHas = fg.getAnnotations();
        if (this.annotations != null) {
            for (int i2 = 0; i2 < this.annotations.length; ++i2) {
                AnnotationAJ array_element = this.annotations[i2];
                boolean alreadyHasIt = false;
                for (AnnotationGen gen : alreadyHas) {
                    if (!gen.getTypeName().equals(array_element.getTypeName())) continue;
                    alreadyHasIt = true;
                    break;
                }
                if (alreadyHasIt) continue;
                fg.addAnnotation(new AnnotationGen(((BcelAnnotation)array_element).getBcelAnnotation(), cpg, true));
            }
        }
        this.field = fg.getField();
        this.annotationsAdded = false;
        return this.field;
    }

    private void unpackGenericSignature() {
        if (this.unpackedGenericSignature) {
            return;
        }
        if (!this.world.isInJava5Mode()) {
            this.genericFieldType = this.getReturnType();
            return;
        }
        this.unpackedGenericSignature = true;
        String gSig = this.field.getGenericSignature();
        if (gSig != null) {
            GenericSignature.FieldTypeSignature fts = new GenericSignatureParser().parseAsFieldSignature(gSig);
            GenericSignature.ClassSignature genericTypeSig = this.bcelObjectType.getGenericClassTypeSignature();
            GenericSignature.FormalTypeParameter[] parentFormals = this.bcelObjectType.getAllFormals();
            GenericSignature.FormalTypeParameter[] typeVars = genericTypeSig == null ? new GenericSignature.FormalTypeParameter[]{} : genericTypeSig.formalTypeParameters;
            GenericSignature.FormalTypeParameter[] formals = new GenericSignature.FormalTypeParameter[parentFormals.length + typeVars.length];
            System.arraycopy(typeVars, 0, formals, 0, typeVars.length);
            System.arraycopy(parentFormals, 0, formals, typeVars.length, parentFormals.length);
            try {
                this.genericFieldType = BcelGenericSignatureToTypeXConverter.fieldTypeSignature2TypeX(fts, formals, this.world);
            }
            catch (BcelGenericSignatureToTypeXConverter.GenericSignatureFormatException e2) {
                throw new IllegalStateException("While determing the generic field type of " + this.toString() + " with generic signature " + gSig + " the following error was detected: " + e2.getMessage());
            }
        } else {
            this.genericFieldType = this.getReturnType();
        }
    }

    public void evictWeavingState() {
        if (this.field != null) {
            this.unpackGenericSignature();
            this.unpackAttributes(this.world);
            this.ensureAnnotationTypesRetrieved();
            this.field = null;
        }
    }
}

