/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import org.aspectj.weaver.BCException;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.MemberKind;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.World;

public class SignatureUtils {
    public static String getSignatureString(Member m2, World world) {
        MemberKind kind = m2.getKind();
        if (kind == Member.METHOD) {
            return SignatureUtils.getMethodSignatureString(m2, world);
        }
        if (kind == Member.CONSTRUCTOR) {
            return SignatureUtils.getConstructorSignatureString(m2, world);
        }
        if (kind == Member.FIELD) {
            return SignatureUtils.getFieldSignatureString(m2, world);
        }
        if (kind == Member.HANDLER) {
            return SignatureUtils.getHandlerSignatureString(m2, world);
        }
        if (kind == Member.STATIC_INITIALIZATION) {
            return SignatureUtils.getStaticInitializationSignatureString(m2, world);
        }
        if (kind == Member.ADVICE) {
            return SignatureUtils.getAdviceSignatureString(m2, world);
        }
        if (kind == Member.MONITORENTER || kind == Member.MONITOREXIT) {
            return SignatureUtils.getMonitorSignatureString(m2, world);
        }
        throw new BCException("Do not know the signature string for MemberKind " + kind);
    }

    public static String getSignatureMakerName(Member m2) {
        MemberKind kind = m2.getKind();
        if (kind == Member.METHOD) {
            return "makeMethodSig";
        }
        if (kind == Member.CONSTRUCTOR) {
            return "makeConstructorSig";
        }
        if (kind == Member.FIELD) {
            return "makeFieldSig";
        }
        if (kind == Member.HANDLER) {
            return "makeCatchClauseSig";
        }
        if (kind == Member.STATIC_INITIALIZATION) {
            return "makeInitializerSig";
        }
        if (kind == Member.ADVICE) {
            return "makeAdviceSig";
        }
        if (kind == Member.MONITORENTER) {
            return "makeLockSig";
        }
        if (kind == Member.MONITOREXIT) {
            return "makeUnlockSig";
        }
        throw new BCException("Do not know the signature maker name for MemberKind " + kind);
    }

    public static String getSignatureType(Member m2) {
        MemberKind kind = m2.getKind();
        if (m2.getName().equals("<clinit>") && kind != Member.STATIC_INITIALIZATION) {
            throw new BCException();
        }
        if (kind == Member.METHOD) {
            return "org.aspectj.lang.reflect.MethodSignature";
        }
        if (kind == Member.CONSTRUCTOR) {
            return "org.aspectj.lang.reflect.ConstructorSignature";
        }
        if (kind == Member.FIELD) {
            return "org.aspectj.lang.reflect.FieldSignature";
        }
        if (kind == Member.HANDLER) {
            return "org.aspectj.lang.reflect.CatchClauseSignature";
        }
        if (kind == Member.STATIC_INITIALIZATION) {
            return "org.aspectj.lang.reflect.InitializerSignature";
        }
        if (kind == Member.ADVICE) {
            return "org.aspectj.lang.reflect.AdviceSignature";
        }
        if (kind == Member.MONITORENTER) {
            return "org.aspectj.lang.reflect.LockSignature";
        }
        if (kind == Member.MONITOREXIT) {
            return "org.aspectj.lang.reflect.UnlockSignature";
        }
        throw new BCException("Do not know the signature type for MemberKind " + kind);
    }

    private static String getHandlerSignatureString(Member m2, World world) {
        StringBuffer buf = new StringBuffer();
        buf.append(SignatureUtils.makeString(0));
        buf.append('-');
        buf.append('-');
        buf.append(SignatureUtils.makeString(m2.getDeclaringType()));
        buf.append('-');
        buf.append(SignatureUtils.makeString(m2.getParameterTypes()[0]));
        buf.append('-');
        String pName = "<missing>";
        String[] names = m2.getParameterNames(world);
        if (names != null) {
            pName = names[0];
        }
        buf.append(pName);
        buf.append('-');
        return buf.toString();
    }

    private static String getStaticInitializationSignatureString(Member m2, World world) {
        StringBuffer buf = new StringBuffer();
        buf.append(SignatureUtils.makeString(m2.getModifiers(world)));
        buf.append('-');
        buf.append('-');
        buf.append(SignatureUtils.makeString(m2.getDeclaringType()));
        buf.append('-');
        return buf.toString();
    }

    protected static String getAdviceSignatureString(Member m2, World world) {
        StringBuffer buf = new StringBuffer();
        buf.append(SignatureUtils.makeString(m2.getModifiers(world)));
        buf.append('-');
        buf.append(m2.getName());
        buf.append('-');
        buf.append(SignatureUtils.makeString(m2.getDeclaringType()));
        buf.append('-');
        buf.append(SignatureUtils.makeString(m2.getParameterTypes()));
        buf.append('-');
        buf.append(SignatureUtils.makeString(m2.getParameterNames(world)));
        buf.append('-');
        buf.append(SignatureUtils.makeString(m2.getExceptions(world)));
        buf.append('-');
        buf.append(SignatureUtils.makeString(m2.getReturnType()));
        buf.append('-');
        return buf.toString();
    }

    protected static String getMethodSignatureString(Member m2, World world) {
        StringBuffer buf = new StringBuffer();
        buf.append(SignatureUtils.makeString(m2.getModifiers(world)));
        buf.append('-');
        buf.append(m2.getName());
        buf.append('-');
        buf.append(SignatureUtils.makeString(m2.getDeclaringType()));
        buf.append('-');
        buf.append(SignatureUtils.makeString(m2.getParameterTypes()));
        buf.append('-');
        buf.append(SignatureUtils.makeString(m2.getParameterNames(world)));
        buf.append('-');
        buf.append(SignatureUtils.makeString(m2.getExceptions(world)));
        buf.append('-');
        buf.append(SignatureUtils.makeString(m2.getReturnType()));
        buf.append('-');
        return buf.toString();
    }

    protected static String getMonitorSignatureString(Member m2, World world) {
        StringBuffer buf = new StringBuffer();
        buf.append(SignatureUtils.makeString(8));
        buf.append('-');
        buf.append(m2.getName());
        buf.append('-');
        buf.append(SignatureUtils.makeString(m2.getDeclaringType()));
        buf.append('-');
        buf.append(SignatureUtils.makeString(m2.getParameterTypes()[0]));
        buf.append('-');
        buf.append("");
        buf.append('-');
        return buf.toString();
    }

    protected static String getConstructorSignatureString(Member m2, World world) {
        StringBuffer buf = new StringBuffer();
        buf.append(SignatureUtils.makeString(m2.getModifiers(world)));
        buf.append('-');
        buf.append('-');
        buf.append(SignatureUtils.makeString(m2.getDeclaringType()));
        buf.append('-');
        buf.append(SignatureUtils.makeString(m2.getParameterTypes()));
        buf.append('-');
        buf.append(SignatureUtils.makeString(m2.getParameterNames(world)));
        buf.append('-');
        buf.append(SignatureUtils.makeString(m2.getExceptions(world)));
        buf.append('-');
        return buf.toString();
    }

    protected static String getFieldSignatureString(Member m2, World world) {
        StringBuffer buf = new StringBuffer();
        buf.append(SignatureUtils.makeString(m2.getModifiers(world)));
        buf.append('-');
        buf.append(m2.getName());
        buf.append('-');
        buf.append(SignatureUtils.makeString(m2.getDeclaringType()));
        buf.append('-');
        buf.append(SignatureUtils.makeString(m2.getReturnType()));
        buf.append('-');
        return buf.toString();
    }

    protected static String makeString(int i2) {
        return Integer.toString(i2, 16);
    }

    protected static String makeString(UnresolvedType t) {
        if (t.isArray()) {
            return t.getSignature().replace('/', '.');
        }
        return t.getName();
    }

    protected static String makeString(UnresolvedType[] types) {
        if (types == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        int len = types.length;
        for (int i2 = 0; i2 < len; ++i2) {
            buf.append(SignatureUtils.makeString(types[i2]));
            buf.append(':');
        }
        return buf.toString();
    }

    protected static String makeString(String[] names) {
        if (names == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        int len = names.length;
        for (int i2 = 0; i2 < len; ++i2) {
            buf.append(names[i2]);
            buf.append(':');
        }
        return buf.toString();
    }
}

