/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aspectj.weaver.Advice;
import org.aspectj.weaver.AdviceKind;
import org.aspectj.weaver.Checker;
import org.aspectj.weaver.ConcreteTypeMunger;
import org.aspectj.weaver.ExposeTypeMunger;
import org.aspectj.weaver.PrivilegedAccessMunger;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedMemberImpl;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.ResolvedTypeMunger;
import org.aspectj.weaver.ShadowMunger;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.World;
import org.aspectj.weaver.patterns.Declare;
import org.aspectj.weaver.patterns.DeclareAnnotation;
import org.aspectj.weaver.patterns.DeclareErrorOrWarning;
import org.aspectj.weaver.patterns.DeclareParents;
import org.aspectj.weaver.patterns.DeclarePrecedence;
import org.aspectj.weaver.patterns.DeclareSoft;
import org.aspectj.weaver.patterns.PerClause;
import org.aspectj.weaver.patterns.Pointcut;
import org.aspectj.weaver.patterns.PointcutRewriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrosscuttingMembers {
    private final ResolvedType inAspect;
    private final World world;
    private PerClause perClause;
    private List<ShadowMunger> shadowMungers = new ArrayList<ShadowMunger>(4);
    private List<ConcreteTypeMunger> typeMungers = new ArrayList<ConcreteTypeMunger>(4);
    private List<ConcreteTypeMunger> lateTypeMungers = new ArrayList<ConcreteTypeMunger>(0);
    private Set<DeclareParents> declareParents = new HashSet<DeclareParents>();
    private Set<DeclareSoft> declareSofts = new HashSet<DeclareSoft>();
    private List<Declare> declareDominates = new ArrayList<Declare>(4);
    private Set<DeclareAnnotation> declareAnnotationsOnType = new HashSet<DeclareAnnotation>();
    private Set<DeclareAnnotation> declareAnnotationsOnField = new HashSet<DeclareAnnotation>();
    private Set<DeclareAnnotation> declareAnnotationsOnMethods = new HashSet<DeclareAnnotation>();
    private boolean shouldConcretizeIfNeeded = true;
    private final Hashtable cflowFields = new Hashtable();
    private final Hashtable cflowBelowFields = new Hashtable();

    public CrosscuttingMembers(ResolvedType inAspect, boolean shouldConcretizeIfNeeded) {
        this.inAspect = inAspect;
        this.world = inAspect.getWorld();
        this.shouldConcretizeIfNeeded = shouldConcretizeIfNeeded;
    }

    public void addConcreteShadowMunger(ShadowMunger m2) {
        this.shadowMungers.add(m2);
    }

    public void addShadowMungers(Collection<ShadowMunger> c2) {
        for (ShadowMunger munger : c2) {
            this.addShadowMunger(munger);
        }
    }

    private void addShadowMunger(ShadowMunger m2) {
        if (this.inAspect.isAbstract()) {
            return;
        }
        this.addConcreteShadowMunger(m2.concretize(this.inAspect, this.world, this.perClause));
    }

    public void addTypeMungers(Collection<ConcreteTypeMunger> c2) {
        this.typeMungers.addAll(c2);
    }

    public void addTypeMunger(ConcreteTypeMunger m2) {
        if (m2 == null) {
            throw new Error("FIXME AV - should not happen or what ?");
        }
        this.typeMungers.add(m2);
    }

    public void addLateTypeMungers(Collection<ConcreteTypeMunger> c2) {
        this.lateTypeMungers.addAll(c2);
    }

    public void addLateTypeMunger(ConcreteTypeMunger m2) {
        this.lateTypeMungers.add(m2);
    }

    public void addDeclares(Collection c2) {
        Iterator i2 = c2.iterator();
        while (i2.hasNext()) {
            this.addDeclare((Declare)i2.next());
        }
    }

    public void addDeclare(Declare declare) {
        if (declare instanceof DeclareErrorOrWarning) {
            Checker m2 = new Checker((DeclareErrorOrWarning)declare);
            m2.setDeclaringType(declare.getDeclaringType());
            this.addShadowMunger(m2);
        } else if (declare instanceof DeclarePrecedence) {
            this.declareDominates.add(declare);
        } else if (declare instanceof DeclareParents) {
            DeclareParents dp = (DeclareParents)declare;
            this.exposeTypes(dp.getParents().getExactTypes());
            this.declareParents.add(dp);
        } else if (declare instanceof DeclareSoft) {
            Pointcut concretePointcut;
            DeclareSoft d2 = (DeclareSoft)declare;
            Advice m3 = Advice.makeSoftener(this.world, d2.getPointcut(), d2.getException(), this.inAspect, d2);
            m3.setDeclaringType(d2.getDeclaringType());
            m3.pointcut = concretePointcut = d2.getPointcut().concretize(this.inAspect, d2.getDeclaringType(), 0, m3);
            this.declareSofts.add(new DeclareSoft(d2.getException(), concretePointcut));
            this.addConcreteShadowMunger(m3);
        } else if (declare instanceof DeclareAnnotation) {
            DeclareAnnotation da = (DeclareAnnotation)declare;
            if (da.getAspect() == null) {
                da.setAspect(this.inAspect);
            }
            if (da.isDeclareAtType()) {
                this.declareAnnotationsOnType.add(da);
            } else if (da.isDeclareAtField()) {
                this.declareAnnotationsOnField.add(da);
            } else if (da.isDeclareAtMethod() || da.isDeclareAtConstuctor()) {
                this.declareAnnotationsOnMethods.add(da);
            }
        } else {
            throw new RuntimeException("unimplemented");
        }
    }

    public void exposeTypes(Collection typesToExpose) {
        Iterator i2 = typesToExpose.iterator();
        while (i2.hasNext()) {
            this.exposeType((UnresolvedType)i2.next());
        }
    }

    public void exposeType(UnresolvedType typeToExpose) {
        if (ResolvedType.isMissing(typeToExpose)) {
            return;
        }
        if (typeToExpose.isParameterizedType() || typeToExpose.isRawType()) {
            typeToExpose = typeToExpose instanceof ResolvedType ? ((ResolvedType)typeToExpose).getGenericType() : UnresolvedType.forSignature(typeToExpose.getErasureSignature());
        }
        String signatureToLookFor = typeToExpose.getSignature();
        for (ConcreteTypeMunger cTM : this.typeMungers) {
            String exposedType;
            ResolvedTypeMunger rTM = cTM.getMunger();
            if (rTM == null || !(rTM instanceof ExposeTypeMunger) || !(exposedType = ((ExposeTypeMunger)rTM).getExposedTypeSignature()).equals(signatureToLookFor)) continue;
            return;
        }
        this.addTypeMunger(this.world.getWeavingSupport().concreteTypeMunger(new ExposeTypeMunger(typeToExpose), this.inAspect));
    }

    public void addPrivilegedAccesses(Collection accessedMembers) {
        Iterator i2 = accessedMembers.iterator();
        while (i2.hasNext()) {
            this.addPrivilegedAccess((ResolvedMember)i2.next());
        }
    }

    private void addPrivilegedAccess(ResolvedMember member) {
        this.addTypeMunger(this.world.getWeavingSupport().concreteTypeMunger(new PrivilegedAccessMunger(member), this.inAspect));
    }

    public Collection<ShadowMunger> getCflowEntries() {
        ArrayList<ShadowMunger> ret = new ArrayList<ShadowMunger>();
        for (ShadowMunger m2 : this.shadowMungers) {
            Advice a2;
            if (!(m2 instanceof Advice) || !(a2 = (Advice)m2).getKind().isCflow()) continue;
            ret.add(a2);
        }
        return ret;
    }

    public boolean replaceWith(CrosscuttingMembers other, boolean careAboutShadowMungers) {
        boolean changed = false;
        if (careAboutShadowMungers && (this.perClause == null || !this.perClause.equals(other.perClause))) {
            changed = true;
            this.perClause = other.perClause;
        }
        if (careAboutShadowMungers) {
            HashSet<ShadowMunger> theseShadowMungers = new HashSet<ShadowMunger>();
            HashSet<ShadowMunger> theseInlinedAroundMungers = new HashSet<ShadowMunger>();
            for (ShadowMunger munger : this.shadowMungers) {
                if (munger instanceof Advice) {
                    Advice adviceMunger = (Advice)munger;
                    if (!this.world.isXnoInline() && adviceMunger.getKind().equals(AdviceKind.Around)) {
                        theseInlinedAroundMungers.add(adviceMunger);
                        continue;
                    }
                    theseShadowMungers.add(adviceMunger);
                    continue;
                }
                theseShadowMungers.add(munger);
            }
            HashSet<ShadowMunger> tempSet = new HashSet<ShadowMunger>();
            tempSet.addAll(other.shadowMungers);
            HashSet<ShadowMunger> otherShadowMungers = new HashSet<ShadowMunger>();
            HashSet<ShadowMunger> otherInlinedAroundMungers = new HashSet<ShadowMunger>();
            for (ShadowMunger munger : tempSet) {
                if (munger instanceof Advice) {
                    Advice adviceMunger = (Advice)munger;
                    if (!this.world.isXnoInline() && adviceMunger.getKind().equals(AdviceKind.Around)) {
                        otherInlinedAroundMungers.add(this.rewritePointcutInMunger(adviceMunger));
                        continue;
                    }
                    otherShadowMungers.add(this.rewritePointcutInMunger(adviceMunger));
                    continue;
                }
                otherShadowMungers.add(this.rewritePointcutInMunger(munger));
            }
            if (!((Object)theseShadowMungers).equals(otherShadowMungers)) {
                changed = true;
            }
            if (!this.equivalent(theseInlinedAroundMungers, otherInlinedAroundMungers)) {
                changed = true;
            }
            if (!changed) {
                for (ShadowMunger munger : this.shadowMungers) {
                    int i2 = other.shadowMungers.indexOf(munger);
                    ShadowMunger shadowMunger = other.shadowMungers.get(i2);
                    if (!(munger instanceof Advice)) continue;
                    ((Advice)shadowMunger).setHasMatchedSomething(((Advice)munger).hasMatchedSomething());
                }
            }
            this.shadowMungers = other.shadowMungers;
        }
        HashSet<ConcreteTypeMunger> theseTypeMungers = new HashSet<ConcreteTypeMunger>();
        HashSet<ConcreteTypeMunger> otherTypeMungers = new HashSet<ConcreteTypeMunger>();
        if (!careAboutShadowMungers) {
            ConcreteTypeMunger typeMunger;
            for (ConcreteTypeMunger o2 : this.typeMungers) {
                if (o2 instanceof ConcreteTypeMunger) {
                    typeMunger = o2;
                    if (typeMunger.existsToSupportShadowMunging()) continue;
                    theseTypeMungers.add(typeMunger);
                    continue;
                }
                theseTypeMungers.add(o2);
            }
            for (ConcreteTypeMunger o2 : other.typeMungers) {
                if (o2 instanceof ConcreteTypeMunger) {
                    typeMunger = o2;
                    if (typeMunger.existsToSupportShadowMunging()) continue;
                    otherTypeMungers.add(typeMunger);
                    continue;
                }
                otherTypeMungers.add(o2);
            }
        } else {
            theseTypeMungers.addAll(this.typeMungers);
            otherTypeMungers.addAll(other.typeMungers);
        }
        if (theseTypeMungers.size() != otherTypeMungers.size()) {
            changed = true;
            this.typeMungers = other.typeMungers;
        } else {
            boolean shouldOverwriteThis = false;
            boolean foundInequality = false;
            Iterator iter = theseTypeMungers.iterator();
            while (iter.hasNext() && !foundInequality) {
                Object thisOne = iter.next();
                boolean foundInOtherSet = false;
                for (Object e2 : otherTypeMungers) {
                    if (thisOne instanceof ConcreteTypeMunger && ((ConcreteTypeMunger)thisOne).shouldOverwrite()) {
                        shouldOverwriteThis = true;
                    }
                    if (thisOne instanceof ConcreteTypeMunger && e2 instanceof ConcreteTypeMunger) {
                        if (((ConcreteTypeMunger)thisOne).equivalentTo(e2)) {
                            foundInOtherSet = true;
                            continue;
                        }
                        if (!thisOne.equals(e2)) continue;
                        foundInOtherSet = true;
                        continue;
                    }
                    if (!thisOne.equals(e2)) continue;
                    foundInOtherSet = true;
                }
                if (foundInOtherSet) continue;
                foundInequality = true;
            }
            if (foundInequality) {
                changed = true;
            }
            if (shouldOverwriteThis) {
                this.typeMungers = other.typeMungers;
            }
        }
        if (!((Object)this.lateTypeMungers).equals(other.lateTypeMungers)) {
            changed = true;
            this.lateTypeMungers = other.lateTypeMungers;
        }
        if (!((Object)this.declareDominates).equals(other.declareDominates)) {
            changed = true;
            this.declareDominates = other.declareDominates;
        }
        if (!((Object)this.declareParents).equals(other.declareParents)) {
            if (!careAboutShadowMungers) {
                HashSet<DeclareParents> trimmedThis = new HashSet<DeclareParents>();
                for (DeclareParents decp : this.declareParents) {
                    if (decp.isMixin()) continue;
                    trimmedThis.add(decp);
                }
                HashSet<DeclareParents> trimmedOther = new HashSet<DeclareParents>();
                for (DeclareParents decp : other.declareParents) {
                    if (decp.isMixin()) continue;
                    trimmedOther.add(decp);
                }
                if (!((Object)trimmedThis).equals(trimmedOther)) {
                    changed = true;
                    this.declareParents = other.declareParents;
                }
            } else {
                changed = true;
                this.declareParents = other.declareParents;
            }
        }
        if (!((Object)this.declareSofts).equals(other.declareSofts)) {
            changed = true;
            this.declareSofts = other.declareSofts;
        }
        if (!((Object)this.declareAnnotationsOnType).equals(other.declareAnnotationsOnType)) {
            changed = true;
            this.declareAnnotationsOnType = other.declareAnnotationsOnType;
        }
        if (!((Object)this.declareAnnotationsOnField).equals(other.declareAnnotationsOnField)) {
            changed = true;
            this.declareAnnotationsOnField = other.declareAnnotationsOnField;
        }
        if (!((Object)this.declareAnnotationsOnMethods).equals(other.declareAnnotationsOnMethods)) {
            changed = true;
            this.declareAnnotationsOnMethods = other.declareAnnotationsOnMethods;
        }
        return changed;
    }

    private boolean equivalent(Set<ShadowMunger> theseInlinedAroundMungers, Set<ShadowMunger> otherInlinedAroundMungers) {
        if (theseInlinedAroundMungers.size() != otherInlinedAroundMungers.size()) {
            return false;
        }
        for (Advice advice : theseInlinedAroundMungers) {
            boolean foundIt = false;
            for (Advice advice2 : otherInlinedAroundMungers) {
                if (!advice.equals(advice2)) continue;
                if (advice.getSignature() instanceof ResolvedMemberImpl && ((ResolvedMemberImpl)advice.getSignature()).isEquivalentTo(advice2.getSignature())) {
                    foundIt = true;
                    continue;
                }
                return false;
            }
            if (foundIt) continue;
            return false;
        }
        return true;
    }

    private ShadowMunger rewritePointcutInMunger(ShadowMunger munger) {
        PointcutRewriter pr = new PointcutRewriter();
        Pointcut p2 = munger.getPointcut();
        Pointcut newP = pr.rewrite(p2);
        if (p2.m_ignoreUnboundBindingForNames.length != 0) {
            newP.m_ignoreUnboundBindingForNames = p2.m_ignoreUnboundBindingForNames;
        }
        munger.setPointcut(newP);
        return munger;
    }

    public void setPerClause(PerClause perClause) {
        this.perClause = this.shouldConcretizeIfNeeded ? perClause.concretize(this.inAspect) : perClause;
    }

    public List<Declare> getDeclareDominates() {
        return this.declareDominates;
    }

    public Collection<DeclareParents> getDeclareParents() {
        return this.declareParents;
    }

    public Collection<DeclareSoft> getDeclareSofts() {
        return this.declareSofts;
    }

    public List<ShadowMunger> getShadowMungers() {
        return this.shadowMungers;
    }

    public List<ConcreteTypeMunger> getTypeMungers() {
        return this.typeMungers;
    }

    public List<ConcreteTypeMunger> getLateTypeMungers() {
        return this.lateTypeMungers;
    }

    public Collection<DeclareAnnotation> getDeclareAnnotationOnTypes() {
        return this.declareAnnotationsOnType;
    }

    public Collection<DeclareAnnotation> getDeclareAnnotationOnFields() {
        return this.declareAnnotationsOnField;
    }

    public Collection<DeclareAnnotation> getDeclareAnnotationOnMethods() {
        return this.declareAnnotationsOnMethods;
    }

    public Map getCflowBelowFields() {
        return this.cflowBelowFields;
    }

    public Map getCflowFields() {
        return this.cflowFields;
    }

    public void clearCaches() {
        this.cflowFields.clear();
        this.cflowBelowFields.clear();
    }
}

