/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.generic;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.aspectj.apache.bcel.classfile.Attribute;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.Field;
import org.aspectj.apache.bcel.classfile.JavaClass;
import org.aspectj.apache.bcel.classfile.Method;
import org.aspectj.apache.bcel.classfile.Modifiers;
import org.aspectj.apache.bcel.classfile.SourceFile;
import org.aspectj.apache.bcel.classfile.Utility;
import org.aspectj.apache.bcel.classfile.annotation.AnnotationGen;
import org.aspectj.apache.bcel.classfile.annotation.RuntimeInvisAnnos;
import org.aspectj.apache.bcel.classfile.annotation.RuntimeVisAnnos;
import org.aspectj.apache.bcel.generic.ClassGenException;
import org.aspectj.apache.bcel.generic.InstructionConstants;
import org.aspectj.apache.bcel.generic.InstructionList;
import org.aspectj.apache.bcel.generic.InvokeInstruction;
import org.aspectj.apache.bcel.generic.MethodGen;
import org.aspectj.apache.bcel.generic.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassGen
extends Modifiers
implements Cloneable {
    private String classname;
    private String superclassname;
    private String filename;
    private int classnameIndex = -1;
    private int superclassnameIndex = -1;
    private int major = 45;
    private int minor = 3;
    private ConstantPool cpool;
    private List<Field> fieldsList = new ArrayList<Field>();
    private List<Method> methodsList = new ArrayList<Method>();
    private List<Attribute> attributesList = new ArrayList<Attribute>();
    private List<String> interfaceList = new ArrayList<String>();
    private List<AnnotationGen> annotationsList = new ArrayList<AnnotationGen>();

    public ClassGen(String classname, String superclassname, String filename, int modifiers, String[] interfacenames, ConstantPool cpool) {
        this.classname = classname;
        this.superclassname = superclassname;
        this.filename = filename;
        this.modifiers = modifiers;
        this.cpool = cpool;
        if (filename != null) {
            this.addAttribute(new SourceFile(cpool.addUtf8("SourceFile"), 2, cpool.addUtf8(filename), cpool));
        }
        this.classnameIndex = cpool.addClass(classname);
        this.superclassnameIndex = cpool.addClass(superclassname);
        if (interfacenames != null) {
            String[] stringArray = interfacenames;
            int n2 = interfacenames.length;
            int n3 = 0;
            while (n3 < n2) {
                String interfacename = stringArray[n3];
                this.addInterface(interfacename);
                ++n3;
            }
        }
    }

    public ClassGen(String classname, String superclassname, String filename, int modifiers, String[] interfacenames) {
        this(classname, superclassname, filename, modifiers, interfacenames, new ConstantPool());
    }

    public ClassGen(JavaClass clazz) {
        Attribute[] attributes;
        this.classnameIndex = clazz.getClassNameIndex();
        this.superclassnameIndex = clazz.getSuperclassNameIndex();
        this.classname = clazz.getClassName();
        this.superclassname = clazz.getSuperclassName();
        this.filename = clazz.getSourceFileName();
        this.modifiers = clazz.getModifiers();
        this.cpool = clazz.getConstantPool().copy();
        this.major = clazz.getMajor();
        this.minor = clazz.getMinor();
        Method[] methods = clazz.getMethods();
        Field[] fields = clazz.getFields();
        String[] interfaces = clazz.getInterfaceNames();
        int i2 = 0;
        while (i2 < interfaces.length) {
            this.addInterface(interfaces[i2]);
            ++i2;
        }
        Attribute[] attributeArray = attributes = clazz.getAttributes();
        int n2 = attributes.length;
        int n3 = 0;
        while (n3 < n2) {
            List<AnnotationGen> annos;
            Attribute attr = attributeArray[n3];
            if (attr instanceof RuntimeVisAnnos) {
                RuntimeVisAnnos rva = (RuntimeVisAnnos)attr;
                annos = rva.getAnnotations();
                for (AnnotationGen a2 : annos) {
                    this.annotationsList.add(new AnnotationGen(a2, this.cpool, false));
                }
            } else if (attr instanceof RuntimeInvisAnnos) {
                RuntimeInvisAnnos ria = (RuntimeInvisAnnos)attr;
                annos = ria.getAnnotations();
                for (AnnotationGen anno : annos) {
                    this.annotationsList.add(new AnnotationGen(anno, this.cpool, false));
                }
            } else {
                this.attributesList.add(attr);
            }
            ++n3;
        }
        int i3 = 0;
        while (i3 < methods.length) {
            this.addMethod(methods[i3]);
            ++i3;
        }
        i3 = 0;
        while (i3 < fields.length) {
            this.addField(fields[i3]);
            ++i3;
        }
    }

    public JavaClass getJavaClass() {
        int[] interfaces = this.getInterfaces();
        Field[] fields = this.getFields();
        Method[] methods = this.getMethods();
        List<Attribute> attributes = null;
        if (this.annotationsList.size() == 0) {
            attributes = this.attributesList;
        } else {
            attributes = new ArrayList<Attribute>();
            attributes.addAll(Utility.getAnnotationAttributes(this.cpool, this.annotationsList));
            attributes.addAll(this.attributesList);
        }
        ConstantPool cp = this.cpool.getFinalConstantPool();
        return new JavaClass(this.classnameIndex, this.superclassnameIndex, this.filename, this.major, this.minor, this.modifiers, cp, interfaces, fields, methods, attributes.toArray(new Attribute[attributes.size()]));
    }

    public void addInterface(String name) {
        this.interfaceList.add(name);
    }

    public void removeInterface(String name) {
        this.interfaceList.remove(name);
    }

    public int getMajor() {
        return this.major;
    }

    public void setMajor(int major) {
        this.major = major;
    }

    public void setMinor(int minor) {
        this.minor = minor;
    }

    public int getMinor() {
        return this.minor;
    }

    public void addAttribute(Attribute a2) {
        this.attributesList.add(a2);
    }

    public void addAnnotation(AnnotationGen a2) {
        this.annotationsList.add(a2);
    }

    public void addMethod(Method m2) {
        this.methodsList.add(m2);
    }

    public void addEmptyConstructor(int access_flags) {
        InstructionList il = new InstructionList();
        il.append(InstructionConstants.THIS);
        il.append(new InvokeInstruction(183, this.cpool.addMethodref(this.superclassname, "<init>", "()V")));
        il.append(InstructionConstants.RETURN);
        MethodGen mg = new MethodGen(access_flags, Type.VOID, Type.NO_ARGS, null, "<init>", this.classname, il, this.cpool);
        mg.setMaxStack(1);
        mg.setMaxLocals();
        this.addMethod(mg.getMethod());
    }

    public void addField(Field f2) {
        this.fieldsList.add(f2);
    }

    public boolean containsField(Field f2) {
        return this.fieldsList.contains(f2);
    }

    public Field containsField(String name) {
        for (Field field : this.fieldsList) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        return null;
    }

    public Method containsMethod(String name, String signature) {
        for (Method method : this.methodsList) {
            if (!method.getName().equals(name) || !method.getSignature().equals(signature)) continue;
            return method;
        }
        return null;
    }

    public void removeAttribute(Attribute a2) {
        this.attributesList.remove(a2);
    }

    public void removeAnnotation(AnnotationGen a2) {
        this.annotationsList.remove(a2);
    }

    public void removeMethod(Method m2) {
        this.methodsList.remove(m2);
    }

    public void replaceMethod(Method old, Method new_) {
        if (new_ == null) {
            throw new ClassGenException("Replacement method must not be null");
        }
        int i2 = this.methodsList.indexOf(old);
        if (i2 < 0) {
            this.methodsList.add(new_);
        } else {
            this.methodsList.set(i2, new_);
        }
    }

    public void replaceField(Field old, Field new_) {
        if (new_ == null) {
            throw new ClassGenException("Replacement method must not be null");
        }
        int i2 = this.fieldsList.indexOf(old);
        if (i2 < 0) {
            this.fieldsList.add(new_);
        } else {
            this.fieldsList.set(i2, new_);
        }
    }

    public void removeField(Field f2) {
        this.fieldsList.remove(f2);
    }

    public String getClassName() {
        return this.classname;
    }

    public String getSuperclassName() {
        return this.superclassname;
    }

    public String getFileName() {
        return this.filename;
    }

    public void setClassName(String name) {
        this.classname = name.replace('/', '.');
        this.classnameIndex = this.cpool.addClass(name);
    }

    public void setSuperclassName(String name) {
        this.superclassname = name.replace('/', '.');
        this.superclassnameIndex = this.cpool.addClass(name);
    }

    public Method[] getMethods() {
        Method[] methods = new Method[this.methodsList.size()];
        this.methodsList.toArray(methods);
        return methods;
    }

    public void setMethods(Method[] methods) {
        this.methodsList.clear();
        int m2 = 0;
        while (m2 < methods.length) {
            this.addMethod(methods[m2]);
            ++m2;
        }
    }

    public void setFields(Field[] fs) {
        this.fieldsList.clear();
        int m2 = 0;
        while (m2 < fs.length) {
            this.addField(fs[m2]);
            ++m2;
        }
    }

    public void setMethodAt(Method method, int pos) {
        this.methodsList.set(pos, method);
    }

    public Method getMethodAt(int pos) {
        return this.methodsList.get(pos);
    }

    public String[] getInterfaceNames() {
        int size = this.interfaceList.size();
        String[] interfaces = new String[size];
        this.interfaceList.toArray(interfaces);
        return interfaces;
    }

    public int[] getInterfaces() {
        int size = this.interfaceList.size();
        int[] interfaces = new int[size];
        int i2 = 0;
        while (i2 < size) {
            interfaces[i2] = this.cpool.addClass(this.interfaceList.get(i2));
            ++i2;
        }
        return interfaces;
    }

    public Field[] getFields() {
        Field[] fields = new Field[this.fieldsList.size()];
        this.fieldsList.toArray(fields);
        return fields;
    }

    public Collection<Attribute> getAttributes() {
        return this.attributesList;
    }

    public AnnotationGen[] getAnnotations() {
        AnnotationGen[] annotations = new AnnotationGen[this.annotationsList.size()];
        this.annotationsList.toArray(annotations);
        return annotations;
    }

    public ConstantPool getConstantPool() {
        return this.cpool;
    }

    public void setConstantPool(ConstantPool constant_pool) {
        this.cpool = constant_pool;
    }

    public void setClassNameIndex(int class_name_index) {
        this.classnameIndex = class_name_index;
        this.classname = this.cpool.getConstantString(class_name_index, (byte)7).replace('/', '.');
    }

    public void setSuperclassNameIndex(int superclass_name_index) {
        this.superclassnameIndex = superclass_name_index;
        this.superclassname = this.cpool.getConstantString(superclass_name_index, (byte)7).replace('/', '.');
    }

    public int getSuperclassNameIndex() {
        return this.superclassnameIndex;
    }

    public int getClassNameIndex() {
        return this.classnameIndex;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e2) {
            System.err.println(e2);
            return null;
        }
    }

    public final boolean isAnnotation() {
        return (this.modifiers & 0x2000) != 0;
    }

    public final boolean isEnum() {
        return (this.modifiers & 0x4000) != 0;
    }

    public long getSUID() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeUTF(this.getClassName());
            int classmods = 0;
            classmods |= this.isPublic() ? 1 : 0;
            classmods |= this.isFinal() ? 16 : 0;
            classmods |= this.isInterface() ? 512 : 0;
            if (this.isAbstract()) {
                if (this.isInterface()) {
                    if (this.methodsList.size() > 0) {
                        classmods |= 0x400;
                    }
                } else {
                    classmods |= 0x400;
                }
            }
            dos.writeInt(classmods);
            Object[] names = this.getInterfaceNames();
            if (names != null) {
                Arrays.sort(names);
                int i2 = 0;
                while (i2 < names.length) {
                    dos.writeUTF((String)names[i2]);
                    ++i2;
                }
            }
            ArrayList<Field> relevantFields = new ArrayList<Field>();
            for (Field field : this.fieldsList) {
                if (field.isPrivate() && field.isStatic() || field.isPrivate() && field.isTransient()) continue;
                relevantFields.add(field);
            }
            Collections.sort(relevantFields, new FieldComparator());
            int relevantFlags = 223;
            for (Field f2 : relevantFields) {
                dos.writeUTF(f2.getName());
                dos.writeInt(relevantFlags & f2.getModifiers());
                dos.writeUTF(f2.getType().getSignature());
            }
            ArrayList<Method> relevantMethods = new ArrayList<Method>();
            ArrayList<Method> relevantCtors = new ArrayList<Method>();
            boolean hasClinit = false;
            for (Method m2 : this.methodsList) {
                boolean couldBeInitializer;
                boolean bl = couldBeInitializer = m2.getName().charAt(0) == '<';
                if (couldBeInitializer && m2.getName().equals("<clinit>")) {
                    hasClinit = true;
                    continue;
                }
                if (couldBeInitializer && m2.getName().equals("<init>")) {
                    if (m2.isPrivate()) continue;
                    relevantCtors.add(m2);
                    continue;
                }
                if (m2.isPrivate()) continue;
                relevantMethods.add(m2);
            }
            Collections.sort(relevantCtors, new ConstructorComparator());
            Collections.sort(relevantMethods, new MethodComparator());
            if (hasClinit) {
                dos.writeUTF("<clinit>");
                dos.writeInt(8);
                dos.writeUTF("()V");
            }
            relevantFlags = 3391;
            for (Method ctor : relevantCtors) {
                dos.writeUTF(ctor.getName());
                dos.writeInt(relevantFlags & ctor.getModifiers());
                dos.writeUTF(ctor.getSignature().replace('/', '.'));
            }
            for (Method m2 : relevantMethods) {
                dos.writeUTF(m2.getName());
                dos.writeInt(relevantFlags & m2.getModifiers());
                dos.writeUTF(m2.getSignature().replace('/', '.'));
            }
            dos.flush();
            dos.close();
            byte[] bs = baos.toByteArray();
            MessageDigest md = MessageDigest.getInstance("SHA");
            byte[] result = md.digest(bs);
            long suid = 0L;
            int pos = result.length > 8 ? 7 : result.length - 1;
            while (pos >= 0) {
                suid = suid << 8 | (long)result[pos--] & 0xFFL;
            }
            return suid;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new RuntimeException("Unable to calculate suid for " + this.getClassName() + ": " + e2.toString());
        }
    }

    public boolean hasAttribute(String attributeName) {
        for (Attribute attr : this.attributesList) {
            if (!attr.getName().equals(attributeName)) continue;
            return true;
        }
        return false;
    }

    public Attribute getAttribute(String attributeName) {
        for (Attribute attr : this.attributesList) {
            if (!attr.getName().equals(attributeName)) continue;
            return attr;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConstructorComparator
    implements Comparator<Method> {
        private ConstructorComparator() {
        }

        @Override
        public int compare(Method m0, Method m1) {
            return m0.getSignature().compareTo(m1.getSignature());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FieldComparator
    implements Comparator<Field> {
        private FieldComparator() {
        }

        @Override
        public int compare(Field f0, Field f1) {
            return f0.getName().compareTo(f1.getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MethodComparator
    implements Comparator<Method> {
        private MethodComparator() {
        }

        @Override
        public int compare(Method m0, Method m1) {
            int result = m0.getName().compareTo(m1.getName());
            if (result == 0) {
                result = m0.getSignature().compareTo(m1.getSignature());
            }
            return result;
        }
    }
}

