/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.apache.bcel.classfile.Attribute;
import org.aspectj.apache.bcel.classfile.ClassFormatException;
import org.aspectj.apache.bcel.classfile.ClassVisitor;
import org.aspectj.apache.bcel.classfile.Code;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.ConstantValue;
import org.aspectj.apache.bcel.classfile.ExceptionTable;
import org.aspectj.apache.bcel.classfile.Signature;
import org.aspectj.apache.bcel.classfile.SourceFile;

public class AttributeUtils {
    public static Attribute[] readAttributes(DataInputStream dataInputstream, ConstantPool cpool) {
        try {
            int length = dataInputstream.readUnsignedShort();
            if (length == 0) {
                return Attribute.NoAttributes;
            }
            Attribute[] attrs = new Attribute[length];
            int i2 = 0;
            while (i2 < length) {
                attrs[i2] = Attribute.readAttribute(dataInputstream, cpool);
                ++i2;
            }
            return attrs;
        }
        catch (IOException e2) {
            throw new ClassFormatException("IOException whilst reading set of attributes: " + e2.toString());
        }
    }

    public static void writeAttributes(Attribute[] attributes, DataOutputStream file) throws IOException {
        if (attributes == null) {
            file.writeShort(0);
        } else {
            file.writeShort(attributes.length);
            int i2 = 0;
            while (i2 < attributes.length) {
                attributes[i2].dump(file);
                ++i2;
            }
        }
    }

    public static Signature getSignatureAttribute(Attribute[] attributes) {
        int i2 = 0;
        while (i2 < attributes.length) {
            if (attributes[i2].tag == 10) {
                return (Signature)attributes[i2];
            }
            ++i2;
        }
        return null;
    }

    public static Code getCodeAttribute(Attribute[] attributes) {
        int i2 = 0;
        while (i2 < attributes.length) {
            if (attributes[i2].tag == 2) {
                return (Code)attributes[i2];
            }
            ++i2;
        }
        return null;
    }

    public static ExceptionTable getExceptionTableAttribute(Attribute[] attributes) {
        int i2 = 0;
        while (i2 < attributes.length) {
            if (attributes[i2].tag == 3) {
                return (ExceptionTable)attributes[i2];
            }
            ++i2;
        }
        return null;
    }

    public static ConstantValue getConstantValueAttribute(Attribute[] attributes) {
        int i2 = 0;
        while (i2 < attributes.length) {
            if (attributes[i2].getTag() == 1) {
                return (ConstantValue)attributes[i2];
            }
            ++i2;
        }
        return null;
    }

    public static void accept(Attribute[] attributes, ClassVisitor visitor) {
        int i2 = 0;
        while (i2 < attributes.length) {
            attributes[i2].accept(visitor);
            ++i2;
        }
    }

    public static boolean hasSyntheticAttribute(Attribute[] attributes) {
        int i2 = 0;
        while (i2 < attributes.length) {
            if (attributes[i2].tag == 7) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public static SourceFile getSourceFileAttribute(Attribute[] attributes) {
        int i2 = 0;
        while (i2 < attributes.length) {
            if (attributes[i2].tag == 0) {
                return (SourceFile)attributes[i2];
            }
            ++i2;
        }
        return null;
    }
}

