/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net.jsse;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLSession;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.net.SSLSessionManager;
import org.apache.tomcat.util.net.SSLSupport;
import org.apache.tomcat.util.net.openssl.ciphers.Cipher;
import org.apache.tomcat.util.res.StringManager;

public class JSSESupport
implements SSLSupport,
SSLSessionManager {
    private static final Log log = LogFactory.getLog(JSSESupport.class);
    private static final StringManager sm = StringManager.getManager(JSSESupport.class);
    private static final Map<String, Integer> keySizeCache = new HashMap<String, Integer>();
    private SSLSession session;

    static void init() {
    }

    public JSSESupport(SSLSession session) {
        this.session = session;
    }

    @Override
    public String getCipherSuite() throws IOException {
        if (this.session == null) {
            return null;
        }
        return this.session.getCipherSuite();
    }

    @Override
    public X509Certificate[] getPeerCertificateChain() throws IOException {
        if (this.session == null) {
            return null;
        }
        Certificate[] certs = null;
        try {
            certs = this.session.getPeerCertificates();
        }
        catch (Throwable t) {
            log.debug((Object)sm.getString("jsseSupport.clientCertError"), t);
            return null;
        }
        if (certs == null) {
            return null;
        }
        X509Certificate[] x509Certs = new X509Certificate[certs.length];
        for (int i2 = 0; i2 < certs.length; ++i2) {
            if (certs[i2] instanceof X509Certificate) {
                x509Certs[i2] = (X509Certificate)certs[i2];
            } else {
                try {
                    byte[] buffer = certs[i2].getEncoded();
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    ByteArrayInputStream stream = new ByteArrayInputStream(buffer);
                    x509Certs[i2] = (X509Certificate)cf.generateCertificate(stream);
                }
                catch (Exception ex) {
                    log.info((Object)sm.getString("jsseSupport.certTranslationError", certs[i2]), (Throwable)ex);
                    return null;
                }
            }
            if (!log.isTraceEnabled()) continue;
            log.trace((Object)("Cert #" + i2 + " = " + x509Certs[i2]));
        }
        if (x509Certs.length < 1) {
            return null;
        }
        return x509Certs;
    }

    @Override
    public Integer getKeySize() throws IOException {
        if (this.session == null) {
            return null;
        }
        return keySizeCache.get(this.session.getCipherSuite());
    }

    @Override
    public String getSessionId() throws IOException {
        if (this.session == null) {
            return null;
        }
        byte[] ssl_session = this.session.getId();
        if (ssl_session == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        for (byte b2 : ssl_session) {
            String digit = Integer.toHexString(b2);
            if (digit.length() < 2) {
                buf.append('0');
            }
            if (digit.length() > 2) {
                digit = digit.substring(digit.length() - 2);
            }
            buf.append(digit);
        }
        return buf.toString();
    }

    public void setSession(SSLSession session) {
        this.session = session;
    }

    @Override
    public void invalidateSession() {
        this.session.invalidate();
    }

    @Override
    public String getProtocol() throws IOException {
        if (this.session == null) {
            return null;
        }
        return this.session.getProtocol();
    }

    static {
        for (Cipher cipher : Cipher.values()) {
            for (String jsseName : cipher.getJsseNames()) {
                keySizeCache.put(jsseName, cipher.getStrength_bits());
            }
        }
    }
}

