/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.collections;

import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;

public final class ConcurrentCache<K, V> {
    private final int size;
    private final Map<K, V> eden;
    private final Map<K, V> longterm;

    public ConcurrentCache(int size) {
        this.size = size;
        this.eden = new ConcurrentHashMap(size);
        this.longterm = new WeakHashMap(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K k2) {
        V v = this.eden.get(k2);
        if (v == null) {
            Map<K, V> map = this.longterm;
            synchronized (map) {
                v = this.longterm.get(k2);
            }
            if (v != null) {
                this.eden.put(k2, v);
            }
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(K k2, V v) {
        if (this.eden.size() >= this.size) {
            Map<K, V> map = this.longterm;
            synchronized (map) {
                this.longterm.putAll(this.eden);
            }
            this.eden.clear();
        }
        this.eden.put(k2, v);
    }
}

