/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.buf;

public final class Ascii {
    private static final byte[] toLower = new byte[256];
    private static final boolean[] isDigit = new boolean[256];
    private static final long OVERFLOW_LIMIT = 0xCCCCCCCCCCCCCCCL;

    public static int toLower(int c2) {
        return toLower[c2 & 0xFF] & 0xFF;
    }

    private static boolean isDigit(int c2) {
        return isDigit[c2 & 0xFF];
    }

    public static long parseLong(byte[] b2, int off, int len) throws NumberFormatException {
        byte c2;
        if (b2 == null || len <= 0 || !Ascii.isDigit(c2 = b2[off++])) {
            throw new NumberFormatException();
        }
        long n2 = c2 - 48;
        while (--len > 0) {
            if (Ascii.isDigit(c2 = b2[off++]) && (n2 < 0xCCCCCCCCCCCCCCCL || n2 == 0xCCCCCCCCCCCCCCCL && c2 - 48 < 8)) {
                n2 = n2 * 10L + (long)c2 - 48L;
                continue;
            }
            throw new NumberFormatException();
        }
        return n2;
    }

    static {
        for (int i2 = 0; i2 < 256; ++i2) {
            Ascii.toLower[i2] = (byte)i2;
        }
        for (int lc = 97; lc <= 122; ++lc) {
            int uc = lc + 65 - 97;
            Ascii.toLower[uc] = (byte)lc;
        }
        for (int d2 = 48; d2 <= 57; ++d2) {
            Ascii.isDigit[d2] = true;
        }
    }
}

