/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.el;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;
import javax.el.ValueExpression;
import org.apache.jasper.el.JspELException;
import org.apache.jasper.el.JspPropertyNotFoundException;
import org.apache.jasper.el.JspPropertyNotWritableException;

public final class JspValueExpression
extends ValueExpression
implements Externalizable {
    private ValueExpression target;
    private String mark;

    public JspValueExpression() {
    }

    public JspValueExpression(String mark, ValueExpression target) {
        this.target = target;
        this.mark = mark;
    }

    @Override
    public Class<?> getExpectedType() {
        return this.target.getExpectedType();
    }

    @Override
    public Class<?> getType(ELContext context) throws NullPointerException, PropertyNotFoundException, ELException {
        context.notifyBeforeEvaluation(this.getExpressionString());
        try {
            Class<?> result = this.target.getType(context);
            context.notifyAfterEvaluation(this.getExpressionString());
            return result;
        }
        catch (PropertyNotFoundException e2) {
            if (e2 instanceof JspPropertyNotFoundException) {
                throw e2;
            }
            throw new JspPropertyNotFoundException(this.mark, e2);
        }
        catch (ELException e3) {
            if (e3 instanceof JspELException) {
                throw e3;
            }
            throw new JspELException(this.mark, e3);
        }
    }

    @Override
    public boolean isReadOnly(ELContext context) throws NullPointerException, PropertyNotFoundException, ELException {
        context.notifyBeforeEvaluation(this.getExpressionString());
        try {
            boolean result = this.target.isReadOnly(context);
            context.notifyAfterEvaluation(this.getExpressionString());
            return result;
        }
        catch (PropertyNotFoundException e2) {
            if (e2 instanceof JspPropertyNotFoundException) {
                throw e2;
            }
            throw new JspPropertyNotFoundException(this.mark, e2);
        }
        catch (ELException e3) {
            if (e3 instanceof JspELException) {
                throw e3;
            }
            throw new JspELException(this.mark, e3);
        }
    }

    @Override
    public void setValue(ELContext context, Object value) throws NullPointerException, PropertyNotFoundException, PropertyNotWritableException, ELException {
        context.notifyBeforeEvaluation(this.getExpressionString());
        try {
            this.target.setValue(context, value);
            context.notifyAfterEvaluation(this.getExpressionString());
        }
        catch (PropertyNotWritableException e2) {
            if (e2 instanceof JspPropertyNotWritableException) {
                throw e2;
            }
            throw new JspPropertyNotWritableException(this.mark, e2);
        }
        catch (PropertyNotFoundException e3) {
            if (e3 instanceof JspPropertyNotFoundException) {
                throw e3;
            }
            throw new JspPropertyNotFoundException(this.mark, e3);
        }
        catch (ELException e4) {
            if (e4 instanceof JspELException) {
                throw e4;
            }
            throw new JspELException(this.mark, e4);
        }
    }

    @Override
    public Object getValue(ELContext context) throws NullPointerException, PropertyNotFoundException, ELException {
        context.notifyBeforeEvaluation(this.getExpressionString());
        try {
            Object result = this.target.getValue(context);
            context.notifyAfterEvaluation(this.getExpressionString());
            return result;
        }
        catch (PropertyNotFoundException e2) {
            if (e2 instanceof JspPropertyNotFoundException) {
                throw e2;
            }
            throw new JspPropertyNotFoundException(this.mark, e2);
        }
        catch (ELException e3) {
            if (e3 instanceof JspELException) {
                throw e3;
            }
            throw new JspELException(this.mark, e3);
        }
    }

    @Override
    public boolean equals(Object obj) {
        return this.target.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.target.hashCode();
    }

    @Override
    public String getExpressionString() {
        return this.target.getExpressionString();
    }

    @Override
    public boolean isLiteralText() {
        return this.target.isLiteralText();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.mark);
        out.writeObject(this.target);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.mark = in.readUTF();
        this.target = (ValueExpression)in.readObject();
    }
}

