/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.remote.http.client;

import java.io.IOException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.jcs.auxiliary.remote.http.client.RemoteHttpCacheAttributes;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractHttpClient {
    private MultiThreadedHttpConnectionManager connectionManager;
    private HttpClient httpClient;
    private RemoteHttpCacheAttributes remoteHttpCacheAttributes;
    private static final Log log = LogFactory.getLog(AbstractHttpClient.class);

    public AbstractHttpClient(RemoteHttpCacheAttributes remoteHttpCacheAttributes) {
        this.remoteHttpCacheAttributes = remoteHttpCacheAttributes;
        this.connectionManager = new MultiThreadedHttpConnectionManager();
        this.httpClient = new HttpClient((HttpConnectionManager)this.connectionManager);
        this.configureClient();
    }

    protected void configureClient() {
        if (this.getRemoteHttpCacheAttributes().getMaxConnectionsPerHost() > 0) {
            this.connectionManager.getParams().setMaxTotalConnections(this.getRemoteHttpCacheAttributes().getMaxConnectionsPerHost());
            this.connectionManager.getParams().setDefaultMaxConnectionsPerHost(this.getRemoteHttpCacheAttributes().getMaxConnectionsPerHost());
        }
        this.connectionManager.getParams().setSoTimeout(this.getRemoteHttpCacheAttributes().getSocketTimeoutMillis());
        String httpVersion = this.getRemoteHttpCacheAttributes().getHttpVersion();
        if (httpVersion != null) {
            if ("1.1".equals(httpVersion)) {
                this.httpClient.getParams().setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_1);
            } else if ("1.0".equals(httpVersion)) {
                this.httpClient.getParams().setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_0);
            } else {
                log.warn("Unrecognized value for 'httpVersion': [" + httpVersion + "]");
            }
        }
        this.connectionManager.getParams().setConnectionTimeout(this.getRemoteHttpCacheAttributes().getConnectionTimeoutMillis());
        this.httpClient.getParams().setCookiePolicy("ignoreCookies");
    }

    protected final void doWebserviceCall(HttpMethod post) throws IOException {
        HttpState httpState = this.preProcessWebserviceCall(post);
        this.httpClient.executeMethod(null, post, httpState);
        this.postProcessWebserviceCall(post, httpState);
    }

    protected abstract HttpState preProcessWebserviceCall(HttpMethod var1) throws IOException;

    protected abstract void postProcessWebserviceCall(HttpMethod var1, HttpState var2) throws IOException;

    protected RemoteHttpCacheAttributes getRemoteHttpCacheAttributes() {
        return this.remoteHttpCacheAttributes;
    }
}

