/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary.remote;

import org.apache.commons.jcs.auxiliary.AbstractAuxiliaryCacheAttributes;
import org.apache.commons.jcs.auxiliary.remote.RemoteLocation;
import org.apache.commons.jcs.auxiliary.remote.behavior.ICommonRemoteCacheAttributes;
import org.apache.commons.jcs.auxiliary.remote.behavior.IRemoteCacheConstants;
import org.apache.commons.jcs.auxiliary.remote.server.behavior.RemoteType;

public class CommonRemoteCacheAttributes
extends AbstractAuxiliaryCacheAttributes
implements ICommonRemoteCacheAttributes {
    private static final long serialVersionUID = -1555143736942374000L;
    private String remoteServiceName = IRemoteCacheConstants.REMOTE_CACHE_SERVICE_VAL;
    private RemoteLocation location;
    private String clusterServers = "";
    private RemoteType remoteType = RemoteType.LOCAL;
    private boolean removeUponRemotePut = true;
    private boolean getOnly = false;
    private boolean localClusterConsistency = false;
    private int rmiSocketFactoryTimeoutMillis = 10000;

    @Override
    public String getRemoteTypeName() {
        return this.remoteType != null ? this.remoteType.toString() : RemoteType.LOCAL.toString();
    }

    @Override
    public void setRemoteTypeName(String s2) {
        RemoteType rt = RemoteType.valueOf(s2);
        if (rt != null) {
            this.remoteType = rt;
        }
    }

    @Override
    public RemoteType getRemoteType() {
        return this.remoteType;
    }

    @Override
    public void setRemoteType(RemoteType p2) {
        this.remoteType = p2;
    }

    @Override
    public String getRemoteServiceName() {
        return this.remoteServiceName;
    }

    @Override
    public void setRemoteServiceName(String s2) {
        this.remoteServiceName = s2;
    }

    @Override
    public void setRemoteLocation(RemoteLocation location) {
        this.location = location;
    }

    @Override
    public void setRemoteLocation(String host, int port) {
        this.location = new RemoteLocation(host, port);
    }

    @Override
    public RemoteLocation getRemoteLocation() {
        return this.location;
    }

    @Override
    public String getClusterServers() {
        return this.clusterServers;
    }

    @Override
    public void setClusterServers(String s2) {
        this.clusterServers = s2;
    }

    @Override
    public boolean getRemoveUponRemotePut() {
        return this.removeUponRemotePut;
    }

    @Override
    public void setRemoveUponRemotePut(boolean r2) {
        this.removeUponRemotePut = r2;
    }

    @Override
    public boolean getGetOnly() {
        return this.getOnly;
    }

    @Override
    public void setGetOnly(boolean r2) {
        this.getOnly = r2;
    }

    @Override
    public boolean isLocalClusterConsistency() {
        return this.localClusterConsistency;
    }

    @Override
    public void setLocalClusterConsistency(boolean r2) {
        this.localClusterConsistency = r2;
    }

    @Override
    public void setRmiSocketFactoryTimeoutMillis(int rmiSocketFactoryTimeoutMillis) {
        this.rmiSocketFactoryTimeoutMillis = rmiSocketFactoryTimeoutMillis;
    }

    @Override
    public int getRmiSocketFactoryTimeoutMillis() {
        return this.rmiSocketFactoryTimeoutMillis;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("\n RemoteCacheAttributes ");
        if (this.location != null) {
            buf.append("\n remoteHost = [" + this.location.getHost() + "]");
            buf.append("\n remotePort = [" + this.location.getPort() + "]");
        }
        buf.append("\n cacheName = [" + this.getCacheName() + "]");
        buf.append("\n remoteType = [" + (Object)((Object)this.remoteType) + "]");
        buf.append("\n removeUponRemotePut = [" + this.removeUponRemotePut + "]");
        buf.append("\n getOnly = [" + this.getOnly + "]");
        return buf.toString();
    }
}

