/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import javax.management.ObjectName;
import org.apache.catalina.Engine;
import org.apache.catalina.Executor;
import org.apache.catalina.JmxEnabled;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.mapper.Mapper;
import org.apache.catalina.mapper.MapperListener;
import org.apache.catalina.util.LifecycleMBeanBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public class StandardService
extends LifecycleMBeanBase
implements Service {
    private static final Log log = LogFactory.getLog(StandardService.class);
    private String name = null;
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.core");
    private Server server = null;
    protected final PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected Connector[] connectors = new Connector[0];
    private final Object connectorsLock = new Object();
    protected final ArrayList<Executor> executors = new ArrayList();
    private Engine engine = null;
    private ClassLoader parentClassLoader = null;
    protected final Mapper mapper = new Mapper();
    protected final MapperListener mapperListener = new MapperListener(this);

    @Override
    public Mapper getMapper() {
        return this.mapper;
    }

    @Override
    public Engine getContainer() {
        return this.engine;
    }

    @Override
    public void setContainer(Engine engine) {
        Engine oldEngine = this.engine;
        if (oldEngine != null) {
            oldEngine.setService(null);
        }
        this.engine = engine;
        if (this.engine != null) {
            this.engine.setService(this);
        }
        if (this.getState().isAvailable()) {
            if (this.engine != null) {
                try {
                    this.engine.start();
                }
                catch (LifecycleException e2) {
                    log.error((Object)sm.getString("standardService.engine.startFailed"), (Throwable)e2);
                }
            }
            try {
                this.mapperListener.stop();
            }
            catch (LifecycleException e3) {
                log.error((Object)sm.getString("standardService.mapperListener.stopFailed"), (Throwable)e3);
            }
            try {
                this.mapperListener.start();
            }
            catch (LifecycleException e4) {
                log.error((Object)sm.getString("standardService.mapperListener.startFailed"), (Throwable)e4);
            }
            if (oldEngine != null) {
                try {
                    oldEngine.stop();
                }
                catch (LifecycleException e5) {
                    log.error((Object)sm.getString("standardService.engine.stopFailed"), (Throwable)e5);
                }
            }
        }
        this.support.firePropertyChange("container", oldEngine, this.engine);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Server getServer() {
        return this.server;
    }

    @Override
    public void setServer(Server server) {
        this.server = server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConnector(Connector connector) {
        Object object = this.connectorsLock;
        synchronized (object) {
            connector.setService(this);
            Connector[] results = new Connector[this.connectors.length + 1];
            System.arraycopy(this.connectors, 0, results, 0, this.connectors.length);
            results[this.connectors.length] = connector;
            this.connectors = results;
            if (this.getState().isAvailable()) {
                try {
                    connector.start();
                }
                catch (LifecycleException e2) {
                    log.error((Object)sm.getString("standardService.connector.startFailed", connector), (Throwable)e2);
                }
            }
            this.support.firePropertyChange("connector", null, connector);
        }
    }

    public ObjectName[] getConnectorNames() {
        ObjectName[] results = new ObjectName[this.connectors.length];
        for (int i2 = 0; i2 < results.length; ++i2) {
            results[i2] = this.connectors[i2].getObjectName();
        }
        return results;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    @Override
    public Connector[] findConnectors() {
        return this.connectors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConnector(Connector connector) {
        Object object = this.connectorsLock;
        synchronized (object) {
            int j2 = -1;
            for (int i2 = 0; i2 < this.connectors.length; ++i2) {
                if (connector != this.connectors[i2]) continue;
                j2 = i2;
                break;
            }
            if (j2 < 0) {
                return;
            }
            if (this.connectors[j2].getState().isAvailable()) {
                try {
                    this.connectors[j2].stop();
                }
                catch (LifecycleException e2) {
                    log.error((Object)sm.getString("standardService.connector.stopFailed", this.connectors[j2]), (Throwable)e2);
                }
            }
            connector.setService(null);
            int k2 = 0;
            Connector[] results = new Connector[this.connectors.length - 1];
            for (int i3 = 0; i3 < this.connectors.length; ++i3) {
                if (i3 == j2) continue;
                results[k2++] = this.connectors[i3];
            }
            this.connectors = results;
            this.support.firePropertyChange("connector", connector, null);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("StandardService[");
        sb.append(this.getName());
        sb.append("]");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addExecutor(Executor ex) {
        ArrayList<Executor> arrayList = this.executors;
        synchronized (arrayList) {
            if (!this.executors.contains(ex)) {
                this.executors.add(ex);
                if (this.getState().isAvailable()) {
                    try {
                        ex.start();
                    }
                    catch (LifecycleException x) {
                        log.error((Object)"Executor.start", (Throwable)x);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Executor[] findExecutors() {
        ArrayList<Executor> arrayList = this.executors;
        synchronized (arrayList) {
            Executor[] arr = new Executor[this.executors.size()];
            this.executors.toArray(arr);
            return arr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Executor getExecutor(String executorName) {
        ArrayList<Executor> arrayList = this.executors;
        synchronized (arrayList) {
            for (Executor executor : this.executors) {
                if (!executorName.equals(executor.getName())) continue;
                return executor;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeExecutor(Executor ex) {
        ArrayList<Executor> arrayList = this.executors;
        synchronized (arrayList) {
            if (this.executors.remove(ex) && this.getState().isAvailable()) {
                try {
                    ex.stop();
                }
                catch (LifecycleException e2) {
                    log.error((Object)"Executor.stop", (Throwable)e2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void startInternal() throws LifecycleException {
        Object object;
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("standardService.start.name", this.name));
        }
        this.setState(LifecycleState.STARTING);
        if (this.engine != null) {
            object = this.engine;
            synchronized (object) {
                this.engine.start();
            }
        }
        object = this.executors;
        synchronized (object) {
            for (Executor executor : this.executors) {
                executor.start();
            }
        }
        this.mapperListener.start();
        object = this.connectorsLock;
        synchronized (object) {
            for (Connector connector : this.connectors) {
                try {
                    if (connector.getState() == LifecycleState.FAILED) continue;
                    connector.start();
                }
                catch (Exception e2) {
                    log.error((Object)sm.getString("standardService.connector.startFailed", connector), (Throwable)e2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void stopInternal() throws LifecycleException {
        ArrayList<Executor> arrayList = this.connectorsLock;
        synchronized (arrayList) {
            for (Connector connector : this.connectors) {
                try {
                    connector.pause();
                }
                catch (Exception e2) {
                    log.error((Object)sm.getString("standardService.connector.pauseFailed", connector), (Throwable)e2);
                }
                connector.getProtocolHandler().closeServerSocketGraceful();
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)sm.getString("standardService.stop.name", this.name));
        }
        this.setState(LifecycleState.STOPPING);
        if (this.engine != null) {
            arrayList = this.engine;
            synchronized (arrayList) {
                this.engine.stop();
            }
        }
        arrayList = this.connectorsLock;
        synchronized (arrayList) {
            for (Connector connector : this.connectors) {
                if (!LifecycleState.STARTED.equals((Object)connector.getState())) continue;
                try {
                    connector.stop();
                }
                catch (Exception e3) {
                    log.error((Object)sm.getString("standardService.connector.stopFailed", connector), (Throwable)e3);
                }
            }
        }
        if (this.mapperListener.getState() != LifecycleState.INITIALIZED) {
            this.mapperListener.stop();
        }
        arrayList = this.executors;
        synchronized (arrayList) {
            for (Executor executor : this.executors) {
                executor.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initInternal() throws LifecycleException {
        super.initInternal();
        if (this.engine != null) {
            this.engine.init();
        }
        for (Executor executor : this.findExecutors()) {
            if (executor instanceof JmxEnabled) {
                ((JmxEnabled)((Object)executor)).setDomain(this.getDomain());
            }
            executor.init();
        }
        this.mapperListener.init();
        Object object = this.connectorsLock;
        synchronized (object) {
            for (Connector connector : this.connectors) {
                try {
                    connector.init();
                }
                catch (Exception e2) {
                    String message = sm.getString("standardService.connector.initFailed", connector);
                    log.error((Object)message, (Throwable)e2);
                    if (!Boolean.getBoolean("org.apache.catalina.startup.EXIT_ON_INIT_FAILURE")) continue;
                    throw new LifecycleException(message);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void destroyInternal() throws LifecycleException {
        this.mapperListener.destroy();
        Object object = this.connectorsLock;
        synchronized (object) {
            for (Connector connector : this.connectors) {
                try {
                    connector.destroy();
                }
                catch (Exception e2) {
                    log.error((Object)sm.getString("standardService.connector.destroyFailed", connector), (Throwable)e2);
                }
            }
        }
        for (Executor executor : this.findExecutors()) {
            executor.destroy();
        }
        if (this.engine != null) {
            this.engine.destroy();
        }
        super.destroyInternal();
    }

    @Override
    public ClassLoader getParentClassLoader() {
        if (this.parentClassLoader != null) {
            return this.parentClassLoader;
        }
        if (this.server != null) {
            return this.server.getParentClassLoader();
        }
        return ClassLoader.getSystemClassLoader();
    }

    @Override
    public void setParentClassLoader(ClassLoader parent) {
        ClassLoader oldParentClassLoader = this.parentClassLoader;
        this.parentClassLoader = parent;
        this.support.firePropertyChange("parentClassLoader", oldParentClassLoader, this.parentClassLoader);
    }

    @Override
    protected String getDomainInternal() {
        String domain = null;
        Engine engine = this.getContainer();
        if (engine != null) {
            domain = engine.getName();
        }
        if (domain == null) {
            domain = this.getName();
        }
        return domain;
    }

    @Override
    public final String getObjectNameKeyProperties() {
        return "type=Service";
    }
}

