/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.io.outputstream;

import java.io.IOException;
import java.io.OutputStream;
import net.lingala.zip4j.io.outputstream.CipherOutputStream;

abstract class CompressedOutputStream
extends OutputStream {
    private CipherOutputStream cipherOutputStream;

    public CompressedOutputStream(CipherOutputStream cipherOutputStream) {
        this.cipherOutputStream = cipherOutputStream;
    }

    @Override
    public void write(int b2) throws IOException {
        this.write(new byte[]{(byte)b2});
    }

    @Override
    public void write(byte[] b2) throws IOException {
        this.write(b2, 0, b2.length);
    }

    @Override
    public void write(byte[] b2, int off, int len) throws IOException {
        this.cipherOutputStream.write(b2, off, len);
    }

    protected void closeEntry() throws IOException {
        this.cipherOutputStream.closeEntry();
    }

    @Override
    public void close() throws IOException {
        this.cipherOutputStream.close();
    }

    public long getCompressedSize() {
        return this.cipherOutputStream.getNumberOfBytesWrittenForThisEntry();
    }
}

