/*
 * Decompiled with CFR 0.152.
 */
package jxl.demo;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import jxl.Cell;
import jxl.CellFeatures;
import jxl.CellReferenceHelper;
import jxl.Sheet;
import jxl.Workbook;

public class Features {
    public Features(Workbook w, OutputStream out, String encoding) throws IOException {
        if (encoding == null || !encoding.equals("UnicodeBig")) {
            encoding = "UTF8";
        }
        try {
            OutputStreamWriter osw = new OutputStreamWriter(out, encoding);
            BufferedWriter bw = new BufferedWriter(osw);
            for (int sheet = 0; sheet < w.getNumberOfSheets(); ++sheet) {
                Sheet s2 = w.getSheet(sheet);
                bw.write(s2.getName());
                bw.newLine();
                Cell[] row = null;
                Cell c2 = null;
                for (int i2 = 0; i2 < s2.getRows(); ++i2) {
                    row = s2.getRow(i2);
                    for (int j2 = 0; j2 < row.length; ++j2) {
                        c2 = row[j2];
                        if (c2.getCellFeatures() == null) continue;
                        CellFeatures features = c2.getCellFeatures();
                        StringBuffer sb = new StringBuffer();
                        CellReferenceHelper.getCellReference(c2.getColumn(), c2.getRow(), sb);
                        bw.write("Cell " + sb.toString() + " contents:  " + c2.getContents());
                        bw.flush();
                        bw.write(" comment: " + features.getComment());
                        bw.flush();
                        bw.newLine();
                    }
                }
            }
            bw.flush();
            bw.close();
        }
        catch (UnsupportedEncodingException e2) {
            System.err.println(e2.toString());
        }
    }
}

