/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import jxl.WorkbookSettings;
import jxl.biff.DisplayFormat;
import jxl.biff.IntegerHelper;
import jxl.biff.StringHelper;
import jxl.biff.Type;
import jxl.biff.WritableRecordData;
import jxl.common.Logger;
import jxl.read.biff.Record;

public class FormatRecord
extends WritableRecordData
implements DisplayFormat,
jxl.format.Format {
    public static Logger logger = Logger.getLogger(FormatRecord.class);
    private boolean initialized;
    private byte[] data;
    private int indexCode;
    private String formatString;
    private boolean date;
    private boolean number;
    private Format format;
    private static String[] dateStrings = new String[]{"dd", "mm", "yy", "hh", "ss", "m/", "/d"};
    public static final BiffType biff8 = new BiffType();
    public static final BiffType biff7 = new BiffType();

    FormatRecord(String fmt, int refno) {
        super(Type.FORMAT);
        this.formatString = fmt;
        this.indexCode = refno;
        this.initialized = true;
    }

    protected FormatRecord() {
        super(Type.FORMAT);
        this.initialized = false;
    }

    protected FormatRecord(FormatRecord fr) {
        super(Type.FORMAT);
        this.initialized = false;
        this.formatString = fr.formatString;
        this.date = fr.date;
        this.number = fr.number;
    }

    public FormatRecord(Record t, WorkbookSettings ws, BiffType biffType) {
        super(t);
        int numchars;
        byte[] data = this.getRecord().getData();
        this.indexCode = IntegerHelper.getInt(data[0], data[1]);
        this.initialized = true;
        if (biffType == biff8) {
            numchars = IntegerHelper.getInt(data[2], data[3]);
            this.formatString = data[4] == 0 ? StringHelper.getString(data, numchars, 5, ws) : StringHelper.getUnicodeString(data, numchars, 5);
        } else {
            numchars = data[2];
            byte[] chars = new byte[numchars];
            System.arraycopy(data, 3, chars, 0, chars.length);
            this.formatString = new String(chars);
        }
        this.date = false;
        this.number = false;
        for (int i2 = 0; i2 < dateStrings.length; ++i2) {
            String dateString = dateStrings[i2];
            if (this.formatString.indexOf(dateString) == -1 && this.formatString.indexOf(dateString.toUpperCase()) == -1) continue;
            this.date = true;
            break;
        }
        if (!(this.date || this.formatString.indexOf(35) == -1 && this.formatString.indexOf(48) == -1)) {
            this.number = true;
        }
    }

    @Override
    public byte[] getData() {
        this.data = new byte[this.formatString.length() * 2 + 3 + 2];
        IntegerHelper.getTwoBytes(this.indexCode, this.data, 0);
        IntegerHelper.getTwoBytes(this.formatString.length(), this.data, 2);
        this.data[4] = 1;
        StringHelper.getUnicodeBytes(this.formatString, this.data, 5);
        return this.data;
    }

    @Override
    public int getFormatIndex() {
        return this.indexCode;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void initialize(int pos) {
        this.indexCode = pos;
        this.initialized = true;
    }

    protected final String replace(String input, String search, String replace) {
        String fmtstr = input;
        int pos = fmtstr.indexOf(search);
        while (pos != -1) {
            StringBuffer tmp = new StringBuffer(fmtstr.substring(0, pos));
            tmp.append(replace);
            tmp.append(fmtstr.substring(pos + search.length()));
            fmtstr = tmp.toString();
            pos = fmtstr.indexOf(search);
        }
        return fmtstr;
    }

    protected final void setFormatString(String s2) {
        this.formatString = s2;
    }

    public final boolean isDate() {
        return this.date;
    }

    public final boolean isNumber() {
        return this.number;
    }

    public final NumberFormat getNumberFormat() {
        if (this.format != null && this.format instanceof NumberFormat) {
            return (NumberFormat)this.format;
        }
        try {
            String fs = this.formatString;
            fs = this.replace(fs, "E+", "E");
            fs = this.replace(fs, "_)", "");
            fs = this.replace(fs, "_", "");
            fs = this.replace(fs, "[Red]", "");
            fs = this.replace(fs, "\\", "");
            this.format = new DecimalFormat(fs);
        }
        catch (IllegalArgumentException e2) {
            this.format = new DecimalFormat("#.###");
        }
        return (NumberFormat)this.format;
    }

    public final DateFormat getDateFormat() {
        int end;
        StringBuffer sb;
        if (this.format != null && this.format instanceof DateFormat) {
            return (DateFormat)this.format;
        }
        String fmt = this.formatString;
        int pos = fmt.indexOf("AM/PM");
        while (pos != -1) {
            sb = new StringBuffer(fmt.substring(0, pos));
            sb.append('a');
            sb.append(fmt.substring(pos + 5));
            fmt = sb.toString();
            pos = fmt.indexOf("AM/PM");
        }
        pos = fmt.indexOf("ss.0");
        while (pos != -1) {
            sb = new StringBuffer(fmt.substring(0, pos));
            sb.append("ss.SSS");
            pos += 4;
            while (pos < fmt.length() && fmt.charAt(pos) == '0') {
                ++pos;
            }
            sb.append(fmt.substring(pos));
            fmt = sb.toString();
            pos = fmt.indexOf("ss.0");
        }
        sb = new StringBuffer();
        for (int i2 = 0; i2 < fmt.length(); ++i2) {
            if (fmt.charAt(i2) == '\\') continue;
            sb.append(fmt.charAt(i2));
        }
        fmt = sb.toString();
        if (fmt.charAt(0) == '[' && (end = fmt.indexOf(93)) != -1) {
            fmt = fmt.substring(end + 1);
        }
        fmt = this.replace(fmt, ";@", "");
        char[] formatBytes = fmt.toCharArray();
        for (int i3 = 0; i3 < formatBytes.length; ++i3) {
            char ind;
            int j2;
            int j3;
            if (formatBytes[i3] != 'm') continue;
            if (i3 > 0 && (formatBytes[i3 - 1] == 'm' || formatBytes[i3 - 1] == 'M')) {
                formatBytes[i3] = formatBytes[i3 - 1];
                continue;
            }
            int minuteDist = Integer.MAX_VALUE;
            for (j3 = i3 - 1; j3 > 0; --j3) {
                if (formatBytes[j3] != 'h') continue;
                minuteDist = i3 - j3;
                break;
            }
            for (j3 = i3 + 1; j3 < formatBytes.length; ++j3) {
                if (formatBytes[j3] != 'h') continue;
                minuteDist = Math.min(minuteDist, j3 - i3);
                break;
            }
            for (j3 = i3 - 1; j3 > 0; --j3) {
                if (formatBytes[j3] != 'H') continue;
                minuteDist = i3 - j3;
                break;
            }
            for (j3 = i3 + 1; j3 < formatBytes.length; ++j3) {
                if (formatBytes[j3] != 'H') continue;
                minuteDist = Math.min(minuteDist, j3 - i3);
                break;
            }
            for (j3 = i3 - 1; j3 > 0; --j3) {
                if (formatBytes[j3] != 's') continue;
                minuteDist = Math.min(minuteDist, i3 - j3);
                break;
            }
            for (j3 = i3 + 1; j3 < formatBytes.length; ++j3) {
                if (formatBytes[j3] != 's') continue;
                minuteDist = Math.min(minuteDist, j3 - i3);
                break;
            }
            int monthDist = Integer.MAX_VALUE;
            for (j2 = i3 - 1; j2 > 0; --j2) {
                if (formatBytes[j2] != 'd') continue;
                monthDist = i3 - j2;
                break;
            }
            for (j2 = i3 + 1; j2 < formatBytes.length; ++j2) {
                if (formatBytes[j2] != 'd') continue;
                monthDist = Math.min(monthDist, j2 - i3);
                break;
            }
            for (j2 = i3 - 1; j2 > 0; --j2) {
                if (formatBytes[j2] != 'y') continue;
                monthDist = Math.min(monthDist, i3 - j2);
                break;
            }
            for (j2 = i3 + 1; j2 < formatBytes.length; ++j2) {
                if (formatBytes[j2] != 'y') continue;
                monthDist = Math.min(monthDist, j2 - i3);
                break;
            }
            if (monthDist < minuteDist) {
                formatBytes[i3] = Character.toUpperCase(formatBytes[i3]);
                continue;
            }
            if (monthDist != minuteDist || monthDist == Integer.MAX_VALUE || (ind = formatBytes[i3 - monthDist]) != 'y' && ind != 'd') continue;
            formatBytes[i3] = Character.toUpperCase(formatBytes[i3]);
        }
        try {
            this.format = new SimpleDateFormat(new String(formatBytes));
        }
        catch (IllegalArgumentException e2) {
            this.format = new SimpleDateFormat("dd MM yyyy hh:mm:ss");
        }
        return (DateFormat)this.format;
    }

    public int getIndexCode() {
        return this.indexCode;
    }

    @Override
    public String getFormatString() {
        return this.formatString;
    }

    @Override
    public boolean isBuiltIn() {
        return false;
    }

    public int hashCode() {
        return this.formatString.hashCode();
    }

    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof FormatRecord)) {
            return false;
        }
        FormatRecord fr = (FormatRecord)o2;
        if (this.initialized && fr.initialized) {
            if (this.date != fr.date || this.number != fr.number) {
                return false;
            }
            return this.formatString.equals(fr.formatString);
        }
        return this.formatString.equals(fr.formatString);
    }

    private static class BiffType {
        private BiffType() {
        }
    }
}

