/*
 * Decompiled with CFR 0.152.
 */
package com.toedter.components;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Calendar;
import java.util.Locale;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class JLocaleChooser
extends JComboBox
implements ItemListener {
    private static final long serialVersionUID = 8152430789764877431L;
    protected JComponent component;
    private Locale[] locales;
    private Locale locale;
    private int localeCount;

    public JLocaleChooser() {
        this((JComponent)null);
    }

    public String getName() {
        return "JLocaleChoose";
    }

    public JLocaleChooser(JComponent jComponent) {
        this.component = jComponent;
        this.addItemListener(this);
        this.locales = Calendar.getAvailableLocales();
        this.localeCount = this.locales.length;
        for (int i2 = 0; i2 < this.localeCount; ++i2) {
            if (this.locales[i2].getCountry().length() <= 0) continue;
            this.addItem(this.locales[i2].getDisplayName());
        }
        this.setLocale(Locale.getDefault());
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        int n2;
        String string = (String)itemEvent.getItem();
        for (n2 = 0; n2 < this.localeCount && !this.locales[n2].getDisplayName().equals(string); ++n2) {
        }
        this.setLocale(this.locales[n2], false);
    }

    private void setLocale(Locale locale, boolean bl) {
        Locale locale2 = this.locale;
        this.locale = locale;
        int n2 = 0;
        if (bl) {
            for (int i2 = 0; i2 < this.localeCount; ++i2) {
                if (this.locales[i2].getCountry().length() <= 0) continue;
                if (this.locales[i2].equals(this.locale)) {
                    this.setSelectedIndex(n2);
                }
                ++n2;
            }
        }
        this.firePropertyChange("locale", locale2, this.locale);
        if (this.component != null) {
            this.component.setLocale(locale);
        }
    }

    public void setLocale(Locale locale) {
        this.setLocale(locale, true);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("LocaleChooser");
        jFrame.getContentPane().add(new JLocaleChooser());
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

