/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.xml;

import com.lowagie.text.Anchor;
import com.lowagie.text.Annotation;
import com.lowagie.text.Cell;
import com.lowagie.text.Chapter;
import com.lowagie.text.Chunk;
import com.lowagie.text.DocListener;
import com.lowagie.text.DocWriter;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ElementTags;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.List;
import com.lowagie.text.ListItem;
import com.lowagie.text.MarkupAttributes;
import com.lowagie.text.Meta;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.Row;
import com.lowagie.text.Section;
import com.lowagie.text.StringCompare;
import com.lowagie.text.Table;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;

public class XmlWriter
extends DocWriter
implements DocListener {
    public static final byte[] PROLOG;
    public static final byte[] DOCTYPE;
    public static final byte[] DTD;
    private static final String[] xmlCode;
    private TreeMap itext = new TreeMap(new StringCompare());

    protected XmlWriter(Document document, OutputStream outputStream) {
        super(document, outputStream);
        this.document.addDocListener(this);
        try {
            outputStream.write(PROLOG);
            outputStream.write(DOCTYPE);
            outputStream.write(DTD);
            outputStream.write(34);
            outputStream.write(62);
            outputStream.write(10);
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    protected XmlWriter(Document document, OutputStream outputStream, String string) {
        super(document, outputStream);
        this.document.addDocListener(this);
        try {
            outputStream.write(PROLOG);
            outputStream.write(DOCTYPE);
            outputStream.write(XmlWriter.getISOBytes(string));
            outputStream.write(34);
            outputStream.write(62);
            outputStream.write(10);
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    public static XmlWriter getInstance(Document document, OutputStream outputStream) {
        return new XmlWriter(document, outputStream);
    }

    public static XmlWriter getInstance(Document document, OutputStream outputStream, String string) {
        return new XmlWriter(document, outputStream, string);
    }

    public boolean add(Element element) throws DocumentException {
        if (this.pause) {
            return false;
        }
        try {
            switch (element.type()) {
                case 1: {
                    this.itext.put("title", ((Meta)element).content());
                    return true;
                }
                case 2: {
                    this.itext.put("subject", ((Meta)element).content());
                    return true;
                }
                case 3: {
                    this.itext.put("keywords", ((Meta)element).content());
                    return true;
                }
                case 4: {
                    this.itext.put("author", ((Meta)element).content());
                    return true;
                }
            }
            this.write(element, 1);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public void open() {
        super.open();
        try {
            this.itext.put("producer", "iTextXML by lowagie.com");
            this.itext.put("creationdate", new Date().toString());
            this.writeStart("itext");
            Iterator iterator = this.itext.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                this.write(string, (String)this.itext.get(string));
            }
            this.os.write(62);
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    public boolean newPage() throws DocumentException {
        if (this.pause || !this.open) {
            return false;
        }
        try {
            this.writeStart("newpage");
            this.writeEnd();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public void close() {
        try {
            this.os.write(10);
            this.writeEnd("itext");
            super.close();
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    private void write(Element element, int n2) throws IOException {
        switch (element.type()) {
            case 10: {
                Chunk chunk = (Chunk)element;
                try {
                    Image image = chunk.getImage();
                    this.write(image, n2);
                    return;
                }
                catch (NullPointerException nullPointerException) {
                    this.addTabs(n2);
                    HashMap hashMap = chunk.getAttributes();
                    if (chunk.font().isStandardFont() && hashMap == null && !XmlWriter.hasMarkupAttributes(chunk)) {
                        this.write(XmlWriter.encode(chunk.content(), n2));
                        return;
                    }
                    if (hashMap != null && hashMap.get("NEWPAGE") != null) {
                        this.writeStart("newpage");
                        this.writeEnd();
                        return;
                    }
                    this.writeStart("chunk");
                    if (!chunk.font().isStandardFont()) {
                        this.write(chunk.font());
                    }
                    if (hashMap != null) {
                        Iterator iterator = hashMap.keySet().iterator();
                        while (iterator.hasNext()) {
                            String string = (String)iterator.next();
                            if (string.equals("LOCALGOTO") || string.equals("LOCALDESTINATION") || string.equals("GENERICTAG")) {
                                String string2 = (String)hashMap.get(string);
                                this.write(string.toLowerCase(), string2);
                            }
                            if (!string.equals("SUBSUPSCRIPT")) continue;
                            this.write(string.toLowerCase(), String.valueOf((Float)hashMap.get(string)));
                        }
                    }
                    if (XmlWriter.hasMarkupAttributes(chunk)) {
                        this.writeMarkupAttributes(chunk);
                    }
                    this.os.write(62);
                    this.write(XmlWriter.encode(chunk.content(), n2));
                    this.writeEnd("chunk");
                    return;
                }
            }
            case 11: {
                Phrase phrase = (Phrase)element;
                this.addTabs(n2);
                this.writeStart("phrase");
                this.write("leading", String.valueOf(phrase.leading()));
                this.write(phrase.font());
                if (XmlWriter.hasMarkupAttributes(phrase)) {
                    this.writeMarkupAttributes(phrase);
                }
                this.os.write(62);
                Iterator iterator = phrase.iterator();
                while (iterator.hasNext()) {
                    this.write((Element)iterator.next(), n2 + 1);
                }
                this.addTabs(n2);
                this.writeEnd("phrase");
                return;
            }
            case 17: {
                Anchor anchor = (Anchor)element;
                this.addTabs(n2);
                this.writeStart("anchor");
                this.write("leading", String.valueOf(anchor.leading()));
                this.write(anchor.font());
                if (anchor.name() != null) {
                    this.write("name", anchor.name());
                }
                if (anchor.reference() != null) {
                    this.write("reference", anchor.reference());
                }
                if (XmlWriter.hasMarkupAttributes(anchor)) {
                    this.writeMarkupAttributes(anchor);
                }
                this.os.write(62);
                Iterator iterator = anchor.iterator();
                while (iterator.hasNext()) {
                    this.write((Element)iterator.next(), n2 + 1);
                }
                this.addTabs(n2);
                this.writeEnd("anchor");
                return;
            }
            case 12: {
                Paragraph paragraph = (Paragraph)element;
                this.addTabs(n2);
                this.writeStart("paragraph");
                this.write("leading", String.valueOf(paragraph.leading()));
                this.write(paragraph.font());
                this.write("align", ElementTags.getAlignment(paragraph.alignment()));
                if (paragraph.indentationLeft() != 0.0f) {
                    this.write("indentationleft", String.valueOf(paragraph.indentationLeft()));
                }
                if (paragraph.indentationRight() != 0.0f) {
                    this.write("indentationright", String.valueOf(paragraph.indentationRight()));
                }
                if (XmlWriter.hasMarkupAttributes(paragraph)) {
                    this.writeMarkupAttributes(paragraph);
                }
                this.os.write(62);
                Iterator iterator = paragraph.iterator();
                while (iterator.hasNext()) {
                    this.write((Element)iterator.next(), n2 + 1);
                }
                this.addTabs(n2);
                this.writeEnd("paragraph");
                return;
            }
            case 13: {
                Section section = (Section)element;
                this.addTabs(n2);
                this.writeStart("section");
                this.writeSection(section, n2);
                this.writeEnd("section");
                return;
            }
            case 16: {
                Chapter chapter = (Chapter)element;
                this.addTabs(n2);
                this.writeStart("chapter");
                if (XmlWriter.hasMarkupAttributes(chapter)) {
                    this.writeMarkupAttributes((MarkupAttributes)((Object)chapter));
                }
                this.writeSection(chapter, n2);
                this.writeEnd("chapter");
                return;
            }
            case 14: {
                List list = (List)element;
                this.addTabs(n2);
                this.writeStart("list");
                this.write("numbered", String.valueOf(list.isNumbered()));
                this.write("symbolindent", String.valueOf(list.symbolIndent()));
                if (list.first() != 1) {
                    this.write("first", String.valueOf(list.first()));
                }
                if (list.indentationLeft() != 0.0f) {
                    this.write("indentationleft", String.valueOf(list.indentationLeft()));
                }
                if (list.indentationRight() != 0.0f) {
                    this.write("indentationright", String.valueOf(list.indentationRight()));
                }
                if (!list.isNumbered()) {
                    this.write("listsymbol", list.symbol().content());
                }
                this.write(list.symbol().font());
                if (XmlWriter.hasMarkupAttributes(list)) {
                    this.writeMarkupAttributes(list);
                }
                this.os.write(62);
                Iterator iterator = list.getItems().iterator();
                while (iterator.hasNext()) {
                    this.write((Element)iterator.next(), n2 + 1);
                }
                this.addTabs(n2);
                this.writeEnd("list");
                return;
            }
            case 15: {
                ListItem listItem = (ListItem)element;
                this.addTabs(n2);
                this.writeStart("listitem");
                this.write("leading", String.valueOf(listItem.leading()));
                this.write(listItem.font());
                this.write("align", ElementTags.getAlignment(listItem.alignment()));
                if (listItem.indentationLeft() != 0.0f) {
                    this.write("indentationleft", String.valueOf(listItem.indentationLeft()));
                }
                if (listItem.indentationRight() != 0.0f) {
                    this.write("indentationright", String.valueOf(listItem.indentationRight()));
                }
                if (XmlWriter.hasMarkupAttributes(listItem)) {
                    this.writeMarkupAttributes(listItem);
                }
                this.os.write(62);
                Iterator iterator = listItem.iterator();
                while (iterator.hasNext()) {
                    this.write((Element)iterator.next(), n2 + 1);
                }
                this.addTabs(n2);
                this.writeEnd("listitem");
                return;
            }
            case 20: {
                Cell cell = (Cell)element;
                this.addTabs(n2);
                this.writeStart("cell");
                this.write(cell);
                this.write("horizontalalign", ElementTags.getAlignment(cell.horizontalAlignment()));
                this.write("verticalalign", ElementTags.getAlignment(cell.verticalAlignment()));
                if (cell.cellWidth() != null) {
                    this.write("width", cell.cellWidth());
                }
                if (cell.colspan() != 1) {
                    this.write("colspan", String.valueOf(cell.colspan()));
                }
                if (cell.rowspan() != 1) {
                    this.write("rowspan", String.valueOf(cell.rowspan()));
                }
                if (cell.header()) {
                    this.write("header", String.valueOf(true));
                }
                if (cell.noWrap()) {
                    this.write("nowrap", String.valueOf(true));
                }
                if (cell.leading() != -1.0f) {
                    this.write("leading", String.valueOf(cell.leading()));
                }
                if (XmlWriter.hasMarkupAttributes(cell)) {
                    this.writeMarkupAttributes(cell);
                }
                this.os.write(62);
                Iterator iterator = cell.getElements();
                while (iterator.hasNext()) {
                    this.write((Element)iterator.next(), n2 + 1);
                }
                this.addTabs(n2);
                this.writeEnd("cell");
                return;
            }
            case 21: {
                Row row = (Row)element;
                this.addTabs(n2);
                this.writeStart("row");
                if (XmlWriter.hasMarkupAttributes(row)) {
                    this.writeMarkupAttributes(row);
                }
                this.os.write(62);
                for (int i2 = 0; i2 < row.columns(); ++i2) {
                    Element element2 = (Element)row.getCell(i2);
                    if (element2 == null) continue;
                    this.write(element2, n2 + 1);
                }
                this.addTabs(n2);
                this.writeEnd("row");
                return;
            }
            case 22: {
                Table table = (Table)element;
                table.complete();
                this.addTabs(n2);
                this.writeStart("table");
                this.write("columns", String.valueOf(table.columns()));
                this.os.write(32);
                this.write("width");
                this.os.write(61);
                this.os.write(34);
                if (!"".equals(table.absWidth())) {
                    this.write(table.absWidth());
                } else {
                    this.write(String.valueOf(table.widthPercentage()));
                    this.write("%");
                }
                this.os.write(34);
                this.write("align", ElementTags.getAlignment(table.alignment()));
                this.write("cellpadding", String.valueOf(table.cellpadding()));
                this.write("cellspacing", String.valueOf(table.cellspacing()));
                this.os.write(32);
                this.write("widths");
                this.os.write(61);
                this.os.write(34);
                float[] fArray = table.getProportionalWidths();
                this.write(String.valueOf(fArray[0]));
                for (int i3 = 1; i3 < fArray.length; ++i3) {
                    this.write(";");
                    this.write(String.valueOf(fArray[i3]));
                }
                this.os.write(34);
                this.write(table);
                if (XmlWriter.hasMarkupAttributes(table)) {
                    this.writeMarkupAttributes(table);
                }
                this.os.write(62);
                Iterator iterator = table.iterator();
                while (iterator.hasNext()) {
                    Row row = (Row)iterator.next();
                    this.write(row, n2 + 1);
                }
                this.addTabs(n2);
                this.writeEnd("table");
                return;
            }
            case 29: {
                Annotation annotation = (Annotation)element;
                this.addTabs(n2);
                this.writeStart("annotation");
                if (annotation.title() != null) {
                    this.write("title", annotation.title());
                }
                if (annotation.content() != null) {
                    this.write("content", annotation.content());
                }
                if (XmlWriter.hasMarkupAttributes(annotation)) {
                    this.writeMarkupAttributes(annotation);
                }
                this.writeEnd();
                return;
            }
            case 32: 
            case 34: 
            case 35: {
                Image image = (Image)element;
                if (image.url() == null) {
                    return;
                }
                this.addTabs(n2);
                this.writeStart("image");
                this.write("url", image.url().toString());
                if ((image.alignment() & 0) > 0) {
                    this.write("align", "Left");
                } else if ((image.alignment() & 2) > 0) {
                    this.write("align", "Right");
                } else if ((image.alignment() & 1) > 0) {
                    this.write("align", "Middle");
                }
                if ((image.alignment() & 8) > 0) {
                    this.write("underlying", String.valueOf(true));
                }
                if ((image.alignment() & 4) > 0) {
                    this.write("textwrap", String.valueOf(true));
                }
                if (image.alt() != null) {
                    this.write("alt", image.alt());
                }
                if (image.hasAbsolutePosition()) {
                    this.write("absolutex", String.valueOf(image.absoluteX()));
                    this.write("absolutey", String.valueOf(image.absoluteY()));
                }
                this.write("plainwidth", String.valueOf(image.plainWidth()));
                this.write("plainheight", String.valueOf(image.plainHeight()));
                if (XmlWriter.hasMarkupAttributes(image)) {
                    this.writeMarkupAttributes(image);
                }
                this.writeEnd();
                return;
            }
        }
    }

    private void writeSection(Section section, int n2) throws IOException {
        Iterator iterator;
        this.write("numberdepth", String.valueOf(section.numberDepth()));
        this.write("depth", String.valueOf(section.depth()));
        this.write("indent", String.valueOf(section.indentation()));
        if (section.indentationLeft() != 0.0f) {
            this.write("indentationleft", String.valueOf(section.indentationLeft()));
        }
        if (section.indentationRight() != 0.0f) {
            this.write("indentationright", String.valueOf(section.indentationRight()));
        }
        this.os.write(62);
        if (section.title() != null) {
            this.addTabs(n2 + 1);
            this.writeStart("title");
            this.write("leading", String.valueOf(section.title().leading()));
            this.write("align", ElementTags.getAlignment(section.title().alignment()));
            if (section.title().indentationLeft() != 0.0f) {
                this.write("indentationleft", String.valueOf(section.title().indentationLeft()));
            }
            if (section.title().indentationRight() != 0.0f) {
                this.write("indentationright", String.valueOf(section.title().indentationRight()));
            }
            this.write(section.title().font());
            this.os.write(62);
            iterator = section.title().iterator();
            if (section.depth() > 0) {
                iterator.next();
            }
            while (iterator.hasNext()) {
                this.write((Element)iterator.next(), n2 + 2);
            }
            this.addTabs(n2 + 1);
            this.writeEnd("title");
        }
        iterator = section.iterator();
        while (iterator.hasNext()) {
            this.write((Element)iterator.next(), n2 + 1);
        }
        this.addTabs(n2);
    }

    private void write(Rectangle rectangle) throws IOException {
        if (rectangle.borderWidth() != -1.0f) {
            this.write("borderwidth", String.valueOf(rectangle.borderWidth()));
            if (rectangle.hasBorder(4)) {
                this.write("left", String.valueOf(true));
            }
            if (rectangle.hasBorder(8)) {
                this.write("right", String.valueOf(true));
            }
            if (rectangle.hasBorder(1)) {
                this.write("top", String.valueOf(true));
            }
            if (rectangle.hasBorder(2)) {
                this.write("bottom", String.valueOf(true));
            }
        }
        if (rectangle.borderColor() != null) {
            this.write("red", String.valueOf(rectangle.borderColor().getRed()));
            this.write("green", String.valueOf(rectangle.borderColor().getGreen()));
            this.write("blue", String.valueOf(rectangle.borderColor().getBlue()));
        }
        if (rectangle.backgroundColor() != null) {
            this.write("bgred", String.valueOf(rectangle.backgroundColor().getRed()));
            this.write("bggreen", String.valueOf(rectangle.backgroundColor().getGreen()));
            this.write("bgblue", String.valueOf(rectangle.backgroundColor().getBlue()));
        }
        if (rectangle.grayFill() > 0.0f) {
            this.write("grayfill", String.valueOf(rectangle.grayFill()));
        }
    }

    static final String encode(String string, int n2) {
        int n3 = string.length();
        int n4 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        block3: for (int i2 = 0; i2 < n3; ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case ' ': {
                    if (i2 - n4 > 60) {
                        n4 = i2;
                        stringBuffer.append("\n");
                        XmlWriter.addTabs(stringBuffer, n2);
                        continue block3;
                    }
                }
                default: {
                    stringBuffer.append(xmlCode[c2]);
                }
            }
        }
        return stringBuffer.toString();
    }

    static final void addTabs(StringBuffer stringBuffer, int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuffer.append("\t");
        }
    }

    private void write(Font font) throws IOException {
        this.write("font", font.getFamilyname());
        if (font.size() != -1.0f) {
            this.write("size", String.valueOf(font.size()));
        }
        if (font.style() != -1) {
            this.os.write(32);
            this.write("fontstyle");
            this.os.write(61);
            this.os.write(34);
            switch (font.style() & 3) {
                case 0: {
                    this.write("normal");
                    break;
                }
                case 1: {
                    this.write("bold");
                    break;
                }
                case 2: {
                    this.write("italic");
                    break;
                }
                case 3: {
                    this.write("bold");
                    this.write(", ");
                    this.write("italic");
                }
            }
            if ((font.style() & 4) > 0) {
                this.write(", ");
                this.write("underline");
            }
            if ((font.style() & 8) > 0) {
                this.write(", ");
                this.write("line-through");
            }
            this.os.write(34);
        }
        if (font.color() != null) {
            this.write("red", String.valueOf(font.color().getRed()));
            this.write("green", String.valueOf(font.color().getGreen()));
            this.write("blue", String.valueOf(font.color().getBlue()));
        }
    }

    static {
        int n2;
        PROLOG = XmlWriter.getISOBytes("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
        DOCTYPE = XmlWriter.getISOBytes("<!DOCTYPE ITEXT SYSTEM \"");
        DTD = XmlWriter.getISOBytes("http://itext.sourceforge.net/itext.dtd");
        xmlCode = new String[256];
        for (n2 = 0; n2 < 10; ++n2) {
            XmlWriter.xmlCode[n2] = "&#00" + n2 + ";";
        }
        for (n2 = 10; n2 < 32; ++n2) {
            XmlWriter.xmlCode[n2] = "&#0" + n2 + ";";
        }
        for (n2 = 32; n2 < 128; ++n2) {
            XmlWriter.xmlCode[n2] = String.valueOf((char)n2);
        }
        XmlWriter.xmlCode[10] = "<newline />\n";
        XmlWriter.xmlCode[34] = "&quot;";
        XmlWriter.xmlCode[39] = "&apos;";
        XmlWriter.xmlCode[38] = "&amp;";
        XmlWriter.xmlCode[60] = "&lt;";
        XmlWriter.xmlCode[62] = "&gt;";
        for (n2 = 128; n2 < 256; ++n2) {
            XmlWriter.xmlCode[n2] = "&#" + n2 + ";";
        }
    }
}

